/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitRepository;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitRebaseUpdater
extends GitUpdater {
    private static final Logger LOG = Logger.getInstance((String)GitRebaseUpdater.class.getName());
    private final GitRebaser myRebaser;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final GitBranchPair myBranchPair;

    public GitRebaseUpdater(@NotNull Project project, @NotNull Git git, @NotNull GitRepository repository, @NotNull GitBranchPair branchPair, @NotNull ProgressIndicator progressIndicator, @NotNull UpdatedFiles updatedFiles) {
        super(project, git, repository, progressIndicator, updatedFiles);
        this.myRebaser = new GitRebaser(this.myProject, git, this.myProgressIndicator);
        this.myChangeListManager = ChangeListManager.getInstance((Project)project);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myBranchPair = branchPair;
    }

    @Override
    public boolean isSaveNeeded() {
        Collection localChanges = (Collection)new LocalChangesUnderRoots(this.myChangeListManager, this.myVcsManager).getChangesUnderRoots(Collections.singletonList(this.myRoot)).get(this.myRoot);
        try {
            return !ContainerUtil.isEmpty((Collection)localChanges) || GitUtil.hasLocalChanges(true, this.myProject, this.myRoot);
        }
        catch (VcsException e) {
            LOG.info("isSaveNeeded failed to check local changes", (Throwable)e);
            return true;
        }
    }

    @Override
    @NotNull
    protected GitUpdateResult doUpdate() {
        LOG.info("doUpdate ");
        String remoteBranch = this.getRemoteBranchToMerge();
        List<String> params = Collections.singletonList(remoteBranch);
        return this.myRebaser.rebase(this.myRoot, params, () -> this.cancel(), null);
    }

    @NotNull
    private String getRemoteBranchToMerge() {
        return this.myBranchPair.getTarget().getName();
    }

    public void cancel() {
        this.myRebaser.abortRebase(this.myRoot);
        this.myProgressIndicator.setText2("Refreshing files for the root " + this.myRoot.getPath());
        this.myRoot.refresh(false, true);
    }

    @NotNull
    GitBranchPair getSourceAndTarget() {
        return this.myBranchPair;
    }

    public String toString() {
        return "Rebase updater";
    }

    public boolean fastForwardMerge() {
        LOG.info("Trying fast-forward merge for " + this.myRoot);
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(this.myProject).getRepositoryForRoot(this.myRoot);
        if (repository == null) {
            LOG.error("Repository is null for " + this.myRoot);
            return false;
        }
        try {
            this.markStart(repository);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark start for repository " + repository, (Throwable)e);
            return false;
        }
        GitCommandResult result2 = this.myGit.merge(repository, this.getRemoteBranchToMerge(), Collections.singletonList("--ff-only"), new GitLineHandlerListener[0]);
        try {
            this.markEnd(repository);
        }
        catch (VcsException e) {
            LOG.info("Couldn't mark end for repository " + repository, (Throwable)e);
            VcsNotifier.getInstance((Project)this.myProject).notifyMinorWarning("Couldn't collect the updated files info", String.format("Update of %s was successful, but we couldn't collect the updated changes because of an error", repository));
        }
        return result2.success();
    }
}

