/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchPopup;
import org.jetbrains.annotations.NotNull;

public class GitBranchesAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        GitRepository repository;
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GitRepository gitRepository = repository = file == null ? GitBranchUtil.getCurrentRepository(project) : GitBranchUtil.getRepositoryOrGuess(project, file);
        if (repository != null) {
            GitBranchPopup.getInstance(project, repository).asListPopup().showCenteredInCurrentWindow(project);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && !project.isDisposed());
    }
}

