/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ignore.IgnoredToExcludedSynchronizer;
import com.intellij.dvcs.ignore.VcsIgnoredHolderUpdateListener;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitDisposable;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.ignore.GitRepositoryIgnoredFilesHolder;
import git4idea.repo.GitBranchState;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitConfig;
import git4idea.repo.GitHooksInfo;
import git4idea.repo.GitModulesFileReader;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitRepositoryReader;
import git4idea.repo.GitRepositoryUpdater;
import git4idea.repo.GitSubmoduleInfo;
import git4idea.repo.GitUntrackedFilesHolder;
import git4idea.status.GitStagingAreaHolder;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRepositoryImpl
extends RepositoryImpl
implements GitRepository {
    private static final Logger LOG = Logger.getInstance(GitRepositoryImpl.class);
    @NotNull
    private final GitVcs myVcs;
    @NotNull
    private final GitRepositoryReader myReader;
    @NotNull
    private final VirtualFile myGitDir;
    @NotNull
    private final GitRepositoryFiles myRepositoryFiles;
    @Nullable
    private final GitUntrackedFilesHolder myUntrackedFilesHolder;
    @Nullable
    private final GitStagingAreaHolder myStagingAreaHolder;
    @Nullable
    private final GitRepositoryIgnoredFilesHolder myIgnoredRepositoryFilesHolder;
    @NotNull
    private volatile GitRepoInfo myInfo;

    private GitRepositoryImpl(@NotNull VirtualFile rootDir, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean light) {
        super(project, rootDir, parentDisposable);
        this.myVcs = GitVcs.getInstance(project);
        this.myGitDir = gitDir;
        this.myRepositoryFiles = GitRepositoryFiles.getInstance(gitDir);
        this.myReader = new GitRepositoryReader(this.myRepositoryFiles);
        this.myInfo = this.readRepoInfo();
        if (!light) {
            this.myStagingAreaHolder = new GitStagingAreaHolder(this);
            this.myUntrackedFilesHolder = new GitUntrackedFilesHolder(this, this.myRepositoryFiles);
            Disposer.register((Disposable)this, (Disposable)this.myUntrackedFilesHolder);
            this.myIgnoredRepositoryFilesHolder = new GitRepositoryIgnoredFilesHolder(project, this, GitRepositoryManager.getInstance(project), Git.getInstance());
            Disposer.register((Disposable)this, (Disposable)this.myIgnoredRepositoryFilesHolder);
            this.myIgnoredRepositoryFilesHolder.addUpdateStateListener(new MyRepositoryIgnoredHolderUpdateListener(project));
            IgnoredToExcludedSynchronizer ignoredToExcludedSynchronizer = (IgnoredToExcludedSynchronizer)project.getService(IgnoredToExcludedSynchronizer.class);
            this.myIgnoredRepositoryFilesHolder.addUpdateStateListener((VcsIgnoredHolderUpdateListener)ignoredToExcludedSynchronizer);
        } else {
            this.myStagingAreaHolder = null;
            this.myUntrackedFilesHolder = null;
            this.myIgnoredRepositoryFilesHolder = null;
        }
    }

    @Deprecated
    @NotNull
    public static GitRepository getInstance(@NotNull VirtualFile root, @NotNull Project project, boolean listenToRepoChanges) {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRoot(root);
        return (GitRepository)ObjectUtils.notNull((Object)repository, () -> GitRepositoryImpl.createInstance(root, project, GitDisposable.getInstance(project), listenToRepoChanges));
    }

    @ApiStatus.Internal
    @NotNull
    public static GitRepository createInstance(@NotNull VirtualFile root, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        return GitRepositoryImpl.createInstance(root, Objects.requireNonNull(GitUtil.findGitDir(root)), project, parentDisposable, listenToRepoChanges);
    }

    @ApiStatus.Internal
    @NotNull
    static GitRepository createInstance(@NotNull VirtualFile root, @NotNull VirtualFile gitDir, @NotNull Project project, @NotNull Disposable parentDisposable, boolean listenToRepoChanges) {
        GitRepositoryImpl repository = new GitRepositoryImpl(root, gitDir, project, parentDisposable, !listenToRepoChanges);
        if (listenToRepoChanges) {
            repository.getUntrackedFilesHolder().setupVfsListener(project);
            repository.getIgnoredFilesHolder().setupListeners();
            repository.setupUpdater();
            GitRepositoryManager.getInstance(project).notifyListenersAsync(repository);
        }
        return repository;
    }

    private void setupUpdater() {
        GitRepositoryUpdater updater = new GitRepositoryUpdater(this, this.myRepositoryFiles);
        Disposer.register((Disposable)this, (Disposable)updater);
        if (this.myIgnoredRepositoryFilesHolder != null) {
            this.myIgnoredRepositoryFilesHolder.startRescan();
        }
    }

    @Override
    @Deprecated
    @NotNull
    public VirtualFile getGitDir() {
        return this.myGitDir;
    }

    @Override
    @NotNull
    public GitRepositoryFiles getRepositoryFiles() {
        return this.myRepositoryFiles;
    }

    @Override
    @NotNull
    public GitStagingAreaHolder getStagingAreaHolder() {
        if (this.myStagingAreaHolder == null) {
            throw new IllegalStateException("Using staging area holder with light git repository instance " + this);
        }
        return this.myStagingAreaHolder;
    }

    @Override
    @NotNull
    public GitUntrackedFilesHolder getUntrackedFilesHolder() {
        if (this.myUntrackedFilesHolder == null) {
            throw new IllegalStateException("Using untracked files holder with light git repository instance " + this);
        }
        return this.myUntrackedFilesHolder;
    }

    @Override
    @NotNull
    public GitRepoInfo getInfo() {
        return this.myInfo;
    }

    @Override
    @Nullable
    public GitLocalBranch getCurrentBranch() {
        return this.myInfo.getCurrentBranch();
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myInfo.getCurrentRevision();
    }

    @NotNull
    public Repository.State getState() {
        return this.myInfo.getState();
    }

    @Nullable
    public String getCurrentBranchName() {
        GitLocalBranch currentBranch = this.getCurrentBranch();
        return currentBranch == null ? null : currentBranch.getName();
    }

    @Override
    @NotNull
    public GitVcs getVcs() {
        return this.myVcs;
    }

    @Override
    @NotNull
    public Collection<GitSubmoduleInfo> getSubmodules() {
        return this.myInfo.getSubmodules();
    }

    @Override
    @NotNull
    public GitBranchesCollection getBranches() {
        GitRepoInfo info = this.myInfo;
        return new GitBranchesCollection(info.getLocalBranchesWithHashes(), info.getRemoteBranchesWithHashes());
    }

    @Override
    @NotNull
    public Collection<GitRemote> getRemotes() {
        return this.myInfo.getRemotes();
    }

    @Override
    @NotNull
    public Collection<GitBranchTrackInfo> getBranchTrackInfos() {
        return this.myInfo.getBranchTrackInfos();
    }

    @Override
    @Nullable
    public GitBranchTrackInfo getBranchTrackInfo(@NotNull String localBranchName) {
        return (GitBranchTrackInfo)this.myInfo.getBranchTrackInfosMap().get((Object)localBranchName);
    }

    @Override
    public boolean isRebaseInProgress() {
        return this.getState() == Repository.State.REBASING;
    }

    @Override
    public boolean isOnBranch() {
        return this.getState() != Repository.State.DETACHED && this.getState() != Repository.State.REBASING;
    }

    public void update() {
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error("Reading Git repository information should not be done on the EDT");
        }
        GitRepoInfo previousInfo = this.myInfo;
        this.myInfo = this.readRepoInfo();
        GitRepositoryImpl.notifyIfRepoChanged(this, previousInfo, this.myInfo);
    }

    @NotNull
    private GitRepoInfo readRepoInfo() {
        StopWatch sw = StopWatch.start((String)("Reading Git repo info in " + DvcsUtil.getShortRepositoryName((Repository)this)));
        File configFile = this.myRepositoryFiles.getConfigFile();
        GitConfig config = GitConfig.read(configFile);
        Collection<GitRemote> remotes = config.parseRemotes();
        GitBranchState state = this.myReader.readState(remotes);
        boolean isShallow = this.myReader.hasShallowCommits();
        Collection<GitBranchTrackInfo> trackInfos = config.parseTrackInfos(state.getLocalBranches().keySet(), state.getRemoteBranches().keySet());
        GitHooksInfo hooksInfo = this.myReader.readHooksInfo();
        Collection<GitSubmoduleInfo> submodules = new GitModulesFileReader().read(this.getSubmoduleFile());
        sw.report(LOG);
        return new GitRepoInfo(state.getCurrentBranch(), state.getCurrentRevision(), state.getState(), new LinkedHashSet<GitRemote>(remotes), new HashMap<GitLocalBranch, Hash>(state.getLocalBranches()), new HashMap<GitRemoteBranch, Hash>(state.getRemoteBranches()), new LinkedHashSet<GitBranchTrackInfo>(trackInfos), submodules, hooksInfo, isShallow);
    }

    @NotNull
    private File getSubmoduleFile() {
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.getRoot()), ".gitmodules");
    }

    private static void notifyIfRepoChanged(@NotNull GitRepository repository, @NotNull GitRepoInfo previousInfo, @NotNull GitRepoInfo info) {
        Project project = repository.getProject();
        if (!project.isDisposed() && !info.equals(previousInfo)) {
            GitRepositoryManager.getInstance(project).notifyListenersAsync(repository);
        }
    }

    @NotNull
    public String toLogString() {
        return "GitRepository " + this.getRoot() + " : " + this.myInfo;
    }

    @NotNull
    public GitRepositoryIgnoredFilesHolder getIgnoredFilesHolder() {
        if (this.myIgnoredRepositoryFilesHolder == null) {
            throw new UnsupportedOperationException("Unsupported for light Git repository");
        }
        return this.myIgnoredRepositoryFilesHolder;
    }

    private static class MyRepositoryIgnoredHolderUpdateListener
    implements VcsIgnoredHolderUpdateListener {
        @NotNull
        private final ChangesViewI myChangesViewI;
        @NotNull
        private final Project myProject;

        MyRepositoryIgnoredHolderUpdateListener(@NotNull Project project) {
            this.myChangesViewI = ChangesViewManager.getInstance((Project)project);
            this.myProject = project;
        }

        public void updateStarted() {
            this.myChangesViewI.scheduleRefresh();
        }

        public void updateFinished(@NotNull Collection<FilePath> ignoredPaths, boolean isFullRescan) {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.myChangesViewI.scheduleRefresh();
        }
    }
}

