/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitVcs;
import git4idea.branch.GitRebaseParams;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.interactive.CantRebaseUsingLogException;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogEditorHandler;
import git4idea.rebase.interactive.GitRebaseEntryGeneratedUsingLog;
import git4idea.rebase.interactive.dialog.GitInteractiveRebaseDialog;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getEntriesUsingLog", "", "Lgit4idea/rebase/interactive/GitRebaseEntryGeneratedUsingLog;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "interactivelyRebaseUsingLog", "", "startInteractiveRebase", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "intellij.vcs.git"})
public final class GitInteractiveRebaseUsingLogKt {
    private static final Logger LOG = LoggerKt.logger((String)"Git.Interactive.Rebase.Using.Log");

    @VisibleForTesting
    @NotNull
    public static final List<GitRebaseEntryGeneratedUsingLog> getEntriesUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit2, @NotNull VcsLogData logData) throws CantRebaseUsingLogException {
        boolean bl;
        List<? extends VcsCommitMetadata> details;
        VcsCommitMetadata it;
        Object item$iv$iv;
        Iterator iterator;
        List<? extends VcsCommitMetadata> $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Iterable<Object> $this$map$iv;
        boolean $i$f$map;
        Object object;
        Object object2;
        block11: {
            Project project = repository.getProject();
            VirtualFile root = repository.getRoot();
            DataPack dataPack = logData.getDataPack();
            PermanentGraph permanentGraph = dataPack.getPermanentGraph();
            if (permanentGraph == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl<kotlin.Int>");
            }
            PermanentGraphImpl permanentGraph2 = (PermanentGraphImpl)permanentGraph;
            PermanentCommitsInfoImpl commitsInfo = permanentGraph2.getPermanentCommitsInfo();
            VcsRef vcsRef = VcsLogUtil.findBranch((RefsModel)dataPack.getRefsModel(), (VirtualFile)root, (String)"HEAD");
            if (vcsRef == null) {
                throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNRESOLVED_HEAD);
            }
            VcsRef headRef = vcsRef;
            int headIndex = logData.getCommitIndex(headRef.getCommitHash(), root);
            int headId = commitsInfo.getNodeId((Object)headIndex);
            LiteLinearGraph graph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)((LinearGraph)permanentGraph2.getLinearGraph()));
            BitSetFlags used = new BitSetFlags(permanentGraph2.getLinearGraph().nodesCount());
            boolean bl2 = false;
            List commits2 = new ArrayList();
            new DfsWalk((Collection)CollectionsKt.listOf((Object)headId), graph, (Flags)used).walk(true, (Function1)new Function1<Integer, Boolean>(graph, permanentGraph2, logData, commits2, commit2){
                final /* synthetic */ LiteLinearGraph $graph;
                final /* synthetic */ PermanentGraphImpl $permanentGraph;
                final /* synthetic */ VcsLogData $logData;
                final /* synthetic */ List $commits;
                final /* synthetic */ VcsShortCommitDetails $commit;

                public final boolean invoke(int nodeId) {
                    CommitId commitId;
                    ProgressManager.checkCanceled();
                    List parents = this.$graph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
                    if (parents.size() == 1) {
                        int commitId2 = ((Number)this.$permanentGraph.getPermanentCommitsInfo().getCommitId(nodeId)).intValue();
                        commitId = this.$logData.getCommitId(commitId2);
                        if (commitId == null) {
                            Intrinsics.throwNpe();
                        }
                    } else {
                        throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.MERGE);
                    }
                    Hash hash = commitId.getHash();
                    this.$commits.add(hash);
                    return Intrinsics.areEqual((Object)hash, (Object)this.$commit.getId()) ^ true;
                }
                {
                    this.$graph = liteLinearGraph;
                    this.$permanentGraph = permanentGraphImpl;
                    this.$logData = vcsLogData;
                    this.$commits = list;
                    this.$commit = vcsShortCommitDetails;
                    super(1);
                }
            });
            if (Intrinsics.areEqual((Object)((Hash)CollectionsKt.last((List)commits2)), (Object)commit2.getId()) ^ true) {
                throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNEXPECTED_HASH);
            }
            try {
                Collection<String> collection;
                Iterable iterable = commits2;
                VirtualFile virtualFile = repository.getRoot();
                object2 = GitVcs.getInstance(project);
                object = project;
                $i$f$map = false;
                void var17_22 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    Hash hash = (Hash)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string = it.asString();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = GitLogUtil.collectMetadata((Project)object, object2, virtualFile, (List<String>)collection);
            }
            catch (VcsException e) {
                throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNRESOLVED_HASH);
            }
            details = $this$map$iv;
            Iterable $this$any$iv = details;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsCommitMetadata it2 = (VcsCommitMetadata)element$iv;
                    boolean bl4 = false;
                    if (!(StringsKt.startsWith$default((String)it2.getSubject(), (String)"fixup!", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it2.getSubject(), (String)"squash!", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.FIXUP_SQUASH);
        }
        $this$map$iv = details;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (VcsCommitMetadata)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            object2 = new GitRebaseEntryGeneratedUsingLog(it);
            object.add(object2);
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    public static final void interactivelyRebaseUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit2, @NotNull VcsLogData logData) {
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        new Task.Backgroundable(repository, commit2, logData, project, root, project, GitBundle.message("rebase.progress.indicator.preparing.title", new Object[0])){
            private List<GitRebaseEntryGeneratedUsingLog> generatedEntries;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $root;

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    this.generatedEntries = GitInteractiveRebaseUsingLogKt.getEntriesUsingLog(this.$repository, this.$commit, this.$logData);
                }
                catch (CantRebaseUsingLogException e) {
                    GitInteractiveRebaseUsingLogKt.access$getLOG$p().warn("Couldn't use log for rebasing: " + e.getMessage());
                }
            }

            public void onSuccess() {
                List<GitRebaseEntryGeneratedUsingLog> list = this.generatedEntries;
                if (list != null) {
                    List<GitRebaseEntryGeneratedUsingLog> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<GitRebaseEntryGeneratedUsingLog> entries = list2;
                    boolean bl3 = false;
                    GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog> dialog2 = new GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog>(this.$project, this.$root, entries);
                    dialog2.show();
                    if (dialog2.isOK()) {
                        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(this.$repository, this.$commit, new GitInteractiveRebaseUsingLogEditorHandler(this.$repository, entries, dialog2.getModel()));
                    }
                } else {
                    GitInteractiveRebaseUsingLogKt.startInteractiveRebase$default(this.$repository, this.$commit, null, 4, null);
                }
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$logData = $captured_local_variable$2;
                this.$project = $captured_local_variable$3;
                this.$root = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    public static final void startInteractiveRebase(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit2, @Nullable GitRebaseEditorHandler editorHandler) {
        new Task.Backgroundable(repository, commit2, editorHandler, repository.getProject(), GitBundle.message("rebase.progress.indicator.title", new Object[0])){
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ GitRebaseEditorHandler $editorHandler;

            public void run(@NotNull ProgressIndicator indicator) {
                GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, this.$repository.getVcs().getVersion(), ((Hash)CollectionsKt.first((List)this.$commit.getParents())).asString(), this.$editorHandler, false, null, 16, null);
                GitRebaseUtils.rebase(this.$repository.getProject(), CollectionsKt.listOf((Object)this.$repository), params, indicator);
            }
            {
                this.$repository = $captured_local_variable$0;
                this.$commit = $captured_local_variable$1;
                this.$editorHandler = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        }.queue();
    }

    public static /* synthetic */ void startInteractiveRebase$default(GitRepository gitRepository, VcsShortCommitDetails vcsShortCommitDetails, GitRebaseEditorHandler gitRebaseEditorHandler, int n, Object object) {
        if ((n & 4) != 0) {
            gitRebaseEditorHandler = null;
        }
        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, gitRebaseEditorHandler);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

