/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.config.UpdateMethod;
import git4idea.push.PushUpdateSettings;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRejectedPushUpdateDialog
extends DialogWrapper {
    public static final int MERGE_EXIT_CODE = 2;
    public static final int REBASE_EXIT_CODE = 3;
    private static final String HTML_IDENT = "&nbsp;&nbsp;&nbsp;&nbsp;";
    public static final String DESCRIPTION_START = "Push of current branch ";
    private final Project myProject;
    private final Collection<? extends GitRepository> myRepositories;
    private final boolean myRebaseOverMergeProblemDetected;
    private final JCheckBox myUpdateAllRoots;
    private final RebaseAction myRebaseAction;
    private final MergeAction myMergeAction;
    private final JCheckBox myAutoUpdateInFuture;

    protected GitRejectedPushUpdateDialog(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull PushUpdateSettings initialSettings, boolean rebaseOverMergeProblemDetected) {
        super(project);
        this.myProject = project;
        this.myRepositories = repositories;
        this.myRebaseOverMergeProblemDetected = rebaseOverMergeProblemDetected;
        this.myUpdateAllRoots = new JCheckBox("Update not rejected repositories as well", initialSettings.shouldUpdateAllRoots());
        this.myUpdateAllRoots.setMnemonic('u');
        this.myAutoUpdateInFuture = new JCheckBox("<html>Remember the update method and update <u>s</u>ilently in the future <br/>(you can change this in Settings/Preferences | Version Control)</html>");
        this.myAutoUpdateInFuture.setMnemonic('s');
        this.myMergeAction = new MergeAction();
        this.myRebaseAction = new RebaseAction();
        this.setDefaultAndFocusedActions(initialSettings.getUpdateMethod());
        this.init();
        this.setTitle("Push Rejected");
    }

    private void setDefaultAndFocusedActions(@Nullable UpdateMethod updateMethod) {
        Action focusedAction;
        AbstractAction defaultAction;
        if (this.myRebaseOverMergeProblemDetected) {
            defaultAction = this.myMergeAction;
            focusedAction = this.getCancelAction();
        } else if (updateMethod == UpdateMethod.REBASE) {
            defaultAction = this.myRebaseAction;
            focusedAction = this.myMergeAction;
        } else {
            defaultAction = this.myMergeAction;
            focusedAction = this.myRebaseAction;
        }
        defaultAction.putValue("DefaultAction", Boolean.TRUE);
        focusedAction.putValue("FocusedAction", Boolean.TRUE);
    }

    protected JComponent createCenterPanel() {
        JBLabel desc = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)this.makeDescription()));
        JPanel options = new JPanel(new BorderLayout());
        if (!this.myRebaseOverMergeProblemDetected) {
            options.add((Component)this.myAutoUpdateInFuture, "South");
        }
        if (!GitUtil.justOneGitRepository(this.myProject)) {
            options.add(this.myUpdateAllRoots);
        }
        int GAP = 15;
        JPanel rootPanel = new JPanel(new BorderLayout(15, 15));
        rootPanel.add((Component)desc);
        rootPanel.add((Component)options, "South");
        JLabel iconLabel = new JLabel(this.myRebaseOverMergeProblemDetected ? UIUtil.getWarningIcon() : UIUtil.getQuestionIcon());
        rootPanel.add((Component)iconLabel, "West");
        return rootPanel;
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.UpdateOnRejectedPushDialog";
    }

    private String makeDescription() {
        if (GitUtil.justOneGitRepository(this.myProject)) {
            assert (!this.myRepositories.isEmpty()) : "repositories are empty";
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " was rejected. <br/>" + this.descriptionEnding();
        }
        if (this.myRepositories.size() == 1) {
            GitRepository repository = this.myRepositories.iterator().next();
            GitBranch currentBranch = GitRejectedPushUpdateDialog.getCurrentBranch(repository);
            return DESCRIPTION_START + GitUIUtil.code(currentBranch.getName()) + " in repository <br/>" + GitUIUtil.code(repository.getPresentableUrl()) + " was rejected. <br/>" + this.descriptionEnding();
        }
        Map<GitRepository, GitBranch> currentBranches = this.getCurrentBranches();
        if (GitRejectedPushUpdateDialog.allBranchesHaveTheSameName(currentBranches)) {
            String branchName = currentBranches.values().iterator().next().getName();
            StringBuilder sb = new StringBuilder(DESCRIPTION_START + GitUIUtil.code(branchName) + " was rejected in repositories <br/>");
            for (GitRepository repository : DvcsUtil.sortRepositories(currentBranches.keySet())) {
                sb.append(HTML_IDENT).append(GitUIUtil.code(repository.getPresentableUrl())).append("<br/>");
            }
            sb.append(this.descriptionEnding());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder("<html>Push of the current branch was rejected: <br/>");
        for (Map.Entry<GitRepository, GitBranch> entry : currentBranches.entrySet()) {
            GitRepository repository = entry.getKey();
            GitBranch currentBranch = entry.getValue();
            sb.append(HTML_IDENT + GitUIUtil.code(currentBranch.getName()) + " in " + GitUIUtil.code(repository.getPresentableUrl()) + "<br/>");
        }
        sb.append(this.descriptionEnding());
        return sb.toString();
    }

    @NotNull
    private String descriptionEnding() {
        String desc = "Remote changes need to be merged before pushing.";
        if (this.myRebaseOverMergeProblemDetected) {
            desc = desc + "<br/><br/>In this case <b>merge is highly recommended</b>, because there are non-pushed merge commits. <br/>Rebasing them can lead to problems.";
        }
        return desc;
    }

    private static boolean allBranchesHaveTheSameName(@NotNull Map<GitRepository, GitBranch> branches2) {
        String name = null;
        for (GitBranch branch : branches2.values()) {
            if (name == null) {
                name = branch.getName();
                continue;
            }
            if (name.equals(branch.getName())) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Map<GitRepository, GitBranch> getCurrentBranches() {
        HashMap<GitRepository, GitBranch> currentBranches = new HashMap<GitRepository, GitBranch>();
        for (GitRepository gitRepository : this.myRepositories) {
            currentBranches.put(gitRepository, GitRejectedPushUpdateDialog.getCurrentBranch(gitRepository));
        }
        return currentBranches;
    }

    @NotNull
    private static GitBranch getCurrentBranch(GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        assert (currentBranch != null) : "Current branch can't be null here. " + repository;
        return currentBranch;
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getCancelAction(), this.myMergeAction, this.myRebaseAction};
    }

    boolean shouldUpdateAll() {
        return this.myUpdateAllRoots.isSelected();
    }

    boolean shouldAutoUpdateInFuture() {
        return this.myAutoUpdateInFuture.isSelected();
    }

    boolean warnsAboutRebaseOverMerge() {
        return this.myRebaseOverMergeProblemDetected;
    }

    @NotNull
    Action getDefaultAction() {
        return Boolean.TRUE.equals(this.myMergeAction.getValue("DefaultAction")) ? this.myMergeAction : this.myRebaseAction;
    }

    private class RebaseAction
    extends AbstractAction {
        RebaseAction() {
            super(GitRejectedPushUpdateDialog.this.myRebaseOverMergeProblemDetected ? "Rebase Anyway" : "&Rebase");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(3);
        }
    }

    private class MergeAction
    extends AbstractAction {
        MergeAction() {
            super("&Merge");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitRejectedPushUpdateDialog.this.close(2);
        }
    }
}

