/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.diff.DiffEditorTitleCustomizer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitBranch;
import git4idea.GitCommit;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt;
import git4idea.merge.GitDefaultMergeDialogCustomizerKt$sam$java_lang_Runnable$0;
import git4idea.merge.MergeConflictMultipleCommitInfoDialog;
import git4idea.merge.RefInfo;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0000\u001a\u001c\u0010\b\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a&\u0010\u000b\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u001a\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u001a*\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0000\u001a6\u0010\u0018\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u001aH\u0000\u001a \u0010\u001b\u001a\u00020\u001c2\b\b\u0001\u0010\u0013\u001a\u00020\u00022\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0000\u001a\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\nH\u0002\u001a\u0012\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a\u0012\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0005H\u0003\u001a\u0012\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002\u001a\u001a\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0002H\u0002\u001a\f\u0010(\u001a\u00020)*\u00020*H\u0002\u00a8\u0006+"}, d2={"getCurrentBranchNameSet", "", "", "roots", "", "Lgit4idea/repo/GitRepository;", "getDefaultLeftPanelTitleForBranch", "branchName", "getDefaultRightPanelTitleForBranch", "baseHash", "Lcom/intellij/vcs/log/Hash;", "getDescriptionForRebase", "rebasingBranch", "baseBranch", "getMergeBranchNameSet", "getSingleCurrentBranchName", "getSingleMergeBranchName", "getTitleWithCommitDetailsCustomizer", "Lcom/intellij/diff/DiffEditorTitleCustomizer;", "title", "repository", "file", "Lcom/intellij/openapi/vcs/FilePath;", "commit", "getTitleWithCommitsRangeDetailsCustomizer", "range", "Lkotlin/Pair;", "getTitleWithShowDetailsAction", "Ljavax/swing/JPanel;", "action", "Lkotlin/Function0;", "", "resolveBranchName", "Lgit4idea/merge/RefInfo;", "hash", "resolveMergeBranch", "resolveMergeBranchOrCherryPick", "resolveRebaseOntoBranch", "tryResolveRef", "ref", "toInt", "", "", "intellij.vcs.git"})
public final class GitDefaultMergeDialogCustomizerKt {
    @NotNull
    public static final String getDescriptionForRebase(@Nullable String rebasingBranch, @Nullable String baseBranch, @Nullable Hash baseHash) {
        String string;
        if (baseBranch != null) {
            Object[] objectArray = new Object[5];
            objectArray[0] = GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null);
            objectArray[1] = XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)rebasingBranch), (String)"b");
            objectArray[2] = XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)baseBranch), (String)"b");
            objectArray[3] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Hash hash = baseHash;
            objectArray[4] = hash != null ? hash.toShortString() : null;
            string = GitBundle.message("merge.dialog.description.rebase.with.onto.branch.label.text", objectArray);
        } else {
            string = baseHash != null ? GitBundle.message("merge.dialog.description.rebase.with.hash.label.text", GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)rebasingBranch), (String)"b"), XmlStringUtil.wrapInHtmlTag((String)baseHash.toShortString(), (String)"b")) : GitBundle.message("merge.dialog.description.rebase.without.onto.info.label.text", GitDefaultMergeDialogCustomizerKt.toInt(rebasingBranch != null), XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)rebasingBranch), (String)"b"));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)string);
    }

    @NotNull
    public static final String getDefaultLeftPanelTitleForBranch(@NotNull String branchName) {
        return XmlStringUtil.wrapInHtml((CharSequence)GitBundle.message("merge.dialog.diff.left.title.default.branch.label.text", XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)branchName), (String)"b")));
    }

    @NotNull
    public static final String getDefaultRightPanelTitleForBranch(@Nullable String branchName, @Nullable Hash baseHash) {
        String string;
        if (branchName != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = XmlStringUtil.wrapInHtmlTag((String)XmlStringUtil.escapeString((String)branchName), (String)"b");
            objectArray[1] = GitDefaultMergeDialogCustomizerKt.toInt(baseHash != null);
            Hash hash = baseHash;
            objectArray[2] = hash != null ? hash.toShortString() : null;
            string = GitBundle.message("merge.dialog.diff.right.title.default.with.onto.branch.label.text", objectArray);
        } else {
            string = baseHash != null ? GitBundle.message("merge.dialog.diff.right.title.default.with.hash.label.text", XmlStringUtil.wrapInHtmlTag((String)baseHash.toShortString(), (String)"b")) : GitBundle.getString("merge.dialog.diff.right.title.default.without.onto.info.label.text");
        }
        return XmlStringUtil.wrapInHtml((CharSequence)string);
    }

    @NonNls
    private static final String resolveMergeBranchOrCherryPick(GitRepository repository) {
        RefInfo mergeBranch = GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
        if (mergeBranch != null) {
            return mergeBranch.getPresentable();
        }
        RefInfo rebaseOntoBranch = GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch.getPresentable();
        }
        Hash cherryHead = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "CHERRY_PICK_HEAD");
        if (cherryHead != null) {
            return "cherry-pick";
        }
        return null;
    }

    private static final RefInfo resolveMergeBranch(GitRepository repository) {
        Hash hash = GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, "MERGE_HEAD");
        if (hash == null) {
            return null;
        }
        Hash mergeHead = hash;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repository, mergeHead);
    }

    private static final RefInfo resolveRebaseOntoBranch(GitRepository repository) {
        Hash hash = GitRebaseUtils.getOntoHash(repository.getProject(), repository.getRoot());
        if (hash == null) {
            return null;
        }
        Hash ontoHash = hash;
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(repository.getProject()).getRepositoryForRoot(repository.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository repo = gitRepository;
        return GitDefaultMergeDialogCustomizerKt.resolveBranchName(repo, ontoHash);
    }

    private static final RefInfo resolveBranchName(GitRepository repository, Hash hash) {
        Collection<GitBranch> branches2 = repository.getBranches().findLocalBranchesByHash(hash);
        if (branches2.isEmpty()) {
            branches2 = repository.getBranches().findRemoteBranchesByHash(hash);
        }
        GitBranch gitBranch = (GitBranch)CollectionsKt.singleOrNull((Iterable)branches2);
        return new RefInfo(hash, gitBranch != null ? gitBranch.getName() : null);
    }

    private static final Hash tryResolveRef(GitRepository repository, String ref) {
        try {
            GitRevisionNumber revision = GitRevisionNumber.resolve(repository.getProject(), repository.getRoot(), ref);
            return HashImpl.build((String)revision.asString());
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public static final String getSingleMergeBranchName(@NotNull Collection<? extends GitRepository> roots) {
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getMergeBranchNameSet(roots));
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> getMergeBranchNameSet(Collection<? extends GitRepository> roots) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = roots;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl2 = false;
            if (GitDefaultMergeDialogCustomizerKt.resolveMergeBranchOrCherryPick(repo) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public static final String getSingleCurrentBranchName(@NotNull Collection<? extends GitRepository> roots) {
        return (String)CollectionsKt.singleOrNull((Iterable)GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots));
    }

    private static final Set<String> getCurrentBranchNameSet(Collection<? extends GitRepository> roots) {
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots), (Function1)getCurrentBranchNameSet.1.INSTANCE));
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NotNull String commit2) {
        return new DiffEditorTitleCustomizer(title, repository, commit2, file){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ String $commit;
            final /* synthetic */ FilePath $file;

            @NotNull
            public final JComponent getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        ChangeListViewerDialog dlg = new ChangeListViewerDialog(this.this$0.$repository.getProject());
                        dlg.loadChangesInBackground((ThrowableComputable)new ThrowableComputable<ChangeListViewerDialog.ChangelistData, VcsException>(this){
                            final /* synthetic */ getTitleWithCommitDetailsCustomizer.1 this$0;

                            public final ChangeListViewerDialog.ChangelistData compute() {
                                GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), this.this$0.this$0.$commit, true, false, false);
                                return new ChangeListViewerDialog.ChangelistData((CommittedChangeList)changeList, this.this$0.this$0.$file);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.setModal(true);
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$commit = string2;
                this.$file = filePath;
            }
        };
    }

    @NotNull
    public static final DiffEditorTitleCustomizer getTitleWithCommitsRangeDetailsCustomizer(@Nls @NotNull String title, @NotNull GitRepository repository, @NotNull FilePath file, @NotNull Pair<String, String> range) {
        return new DiffEditorTitleCustomizer(title, repository, file, range){
            final /* synthetic */ String $title;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ FilePath $file;
            final /* synthetic */ Pair $range;

            @NotNull
            public final JComponent getLabel() {
                return GitDefaultMergeDialogCustomizerKt.getTitleWithShowDetailsAction(this.$title, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                    public final void invoke() {
                        boolean bl = false;
                        List details = new ArrayList<E>();
                        HashSet<E> filteredCommits = new HashSet<E>();
                        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, filteredCommits, details){
                            final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;
                            final /* synthetic */ HashSet $filteredCommits;
                            final /* synthetic */ List $details;

                            public final void run() {
                                GitLogUtil.readFullDetails(this.this$0.this$0.$repository.getProject(), this.this$0.this$0.$repository.getRoot(), (Consumer<? super GitCommit>)((Consumer)new Consumer<GitCommit>(this){
                                    final /* synthetic */ getTitleWithCommitsRangeDetailsCustomizer.1 this$0;

                                    public final void consume(GitCommit commit2) {
                                        VcsCommitMetadataImpl commitMetadata = new VcsCommitMetadataImpl(commit2.getId(), commit2.getParents(), commit2.getCommitTime(), commit2.getRoot(), commit2.getSubject(), commit2.getAuthor(), commit2.getFullMessage(), commit2.getCommitter(), commit2.getAuthorTime());
                                        if (commit2.getAffectedPaths().contains(this.this$0.this$0.this$0.$file)) {
                                            this.this$0.$filteredCommits.add(commitMetadata);
                                        }
                                        this.this$0.$details.add(commitMetadata);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)this.this$0.this$0.$range.getFirst() + ".." + (String)this.this$0.this$0.$range.getSecond());
                            }
                            {
                                this.this$0 = var1_1;
                                this.$filteredCommits = hashSet;
                                this.$details = list;
                            }
                        }, GitBundle.message("merge.dialog.customizer.collecting.details.progress", new Object[0]), true, this.this$0.$repository.getProject());
                        MergeConflictMultipleCommitInfoDialog dlg = new MergeConflictMultipleCommitInfoDialog(this.this$0.$repository.getProject(), this.this$0.$repository.getRoot(), details, (Set<? extends VcsCommitMetadata>)filteredCommits);
                        dlg.setTitle(StringUtil.stripHtml((String)this.this$0.$title, (boolean)false));
                        dlg.show();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
            {
                this.$title = string;
                this.$repository = gitRepository;
                this.$file = filePath;
                this.$range = pair;
            }
        };
    }

    @NotNull
    public static final JPanel getTitleWithShowDetailsAction(@Nls @NotNull String title, @NotNull Function0<Unit> action) {
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel().addToCenter((Component)new JBLabel(title).setCopyable(true));
        String string = GitBundle.message("merge.dialog.customizer.show.details.link.label", new Object[0]);
        Object object = action;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new GitDefaultMergeDialogCustomizerKt$sam$java_lang_Runnable$0(function0);
        }
        return (JPanel)borderLayoutPanel.addToRight((Component)LinkLabel.create((String)string, (Runnable)((Runnable)object)));
    }

    private static final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    public static final /* synthetic */ RefInfo access$resolveMergeBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveMergeBranch(repository);
    }

    public static final /* synthetic */ Set access$getCurrentBranchNameSet(Collection roots) {
        return GitDefaultMergeDialogCustomizerKt.getCurrentBranchNameSet(roots);
    }

    public static final /* synthetic */ RefInfo access$resolveRebaseOntoBranch(GitRepository repository) {
        return GitDefaultMergeDialogCustomizerKt.resolveRebaseOntoBranch(repository);
    }

    public static final /* synthetic */ int access$toInt(boolean $this$access_u24toInt) {
        return GitDefaultMergeDialogCustomizerKt.toInt($this$access_u24toInt);
    }

    public static final /* synthetic */ Hash access$tryResolveRef(GitRepository repository, String ref) {
        return GitDefaultMergeDialogCustomizerKt.tryResolveRef(repository, ref);
    }
}

