/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import git4idea.GitFormatException;
import git4idea.GitUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.DefaultGitLogFullRecordBuilder;
import git4idea.history.DefaultGitLogRecordBuilder;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogRecordBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogParser<R extends GitLogRecord> {
    private static final Logger LOG = Logger.getInstance(GitLogParser.class);
    static final String RECORD_START = "\u0001\u0001";
    static final String ITEMS_SEPARATOR = "\u0002\u0002";
    static final String RECORD_END = "\u0003\u0003";
    private static final int MAX_SEPARATOR_LENGTH = 10;
    private static final char[] CONTROL_CHARS = new char[]{'\u0001', '\u0002', '\u0003'};
    private static final int INPUT_ERROR_MESSAGE_HEAD_LIMIT = 1000000;
    private static final int INPUT_ERROR_MESSAGE_TAIL_LIMIT = 100;
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger();
    private final boolean mySupportsRawBody;
    @NotNull
    private final String myPretty;
    @NotNull
    private final OptionsParser myOptionsParser;
    @NotNull
    private final PathsParser myPathsParser;
    @NotNull
    private final GitLogRecordBuilder<R> myRecordBuilder;
    private final String myRecordStart;
    private final String myRecordEnd;
    private final String myItemsSeparator;
    private boolean myIsInBody = true;

    private GitLogParser(@NotNull GitLogRecordBuilder<R> recordBuilder, boolean supportsRawBody, @NotNull NameStatus nameStatusOption, GitLogOption ... options) {
        this.mySupportsRawBody = supportsRawBody;
        this.myRecordBuilder = recordBuilder;
        this.myRecordStart = RECORD_START + GitLogParser.generateRandomSequence();
        this.myRecordEnd = RECORD_END + GitLogParser.generateRandomSequence();
        this.myItemsSeparator = ITEMS_SEPARATOR + GitLogParser.generateRandomSequence();
        this.myPretty = "--pretty=format:" + this.makeFormatFromOptions(options);
        this.myOptionsParser = new OptionsParser(options);
        this.myPathsParser = new MyPathsParser(nameStatusOption);
    }

    public GitLogParser(@NotNull Project project, @NotNull GitLogRecordBuilder<R> recordBuilder, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        this(recordBuilder, GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(project), nameStatus, options);
    }

    @NotNull
    public static GitLogParser<GitLogFullRecord> createDefaultParser(@NotNull Project project, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        return new GitLogParser<GitLogFullRecord>(project, new DefaultGitLogFullRecordBuilder(), nameStatus, options);
    }

    @NotNull
    public static GitLogParser<GitLogRecord> createDefaultParser(@NotNull Project project, GitLogOption ... options) {
        return new GitLogParser<GitLogRecord>(project, new DefaultGitLogRecordBuilder(), NameStatus.NONE, options);
    }

    @NotNull
    public List<R> parse(@NotNull CharSequence output) {
        ArrayList<R> result2 = new ArrayList<R>();
        List lines = StringUtil.split((CharSequence)output, (CharSequence)"\n", (boolean)true, (boolean)false);
        for (CharSequence line : lines) {
            try {
                R record = this.parseLine(line);
                if (record == null) continue;
                result2.add(record);
            }
            catch (GitFormatException e) {
                this.clear();
                LOG.error((Throwable)e);
            }
        }
        R record = this.finish();
        if (record != null) {
            result2.add(record);
        }
        return result2;
    }

    @Nullable
    public R parseOneRecord(@NotNull CharSequence output) {
        List<R> records = this.parse(output);
        this.clear();
        if (records.isEmpty()) {
            return null;
        }
        return (R)((GitLogRecord)ContainerUtil.getFirstItem(records));
    }

    @Nullable
    public R parseLine(@NotNull CharSequence line) {
        if (this.myPathsParser.expectsPaths()) {
            return this.parseLineWithPaths(line);
        }
        return this.parseLineWithoutPaths(line);
    }

    @Nullable
    private R parseLineWithPaths(@NotNull CharSequence line) {
        if (this.myIsInBody) {
            this.myIsInBody = !this.myOptionsParser.parseLine(line);
        } else {
            if (CharArrayUtil.regionMatches((CharSequence)line, (int)0, (CharSequence)this.myRecordStart)) {
                R record = this.createRecord();
                this.myIsInBody = !this.myOptionsParser.parseLine(line);
                return record;
            }
            this.myPathsParser.parseLine(line);
        }
        return null;
    }

    @Nullable
    private R parseLineWithoutPaths(@NotNull CharSequence line) {
        if (this.myOptionsParser.parseLine(line)) {
            return this.createRecord();
        }
        return null;
    }

    @Nullable
    public R finish() {
        if (this.myOptionsParser.isEmpty()) {
            return null;
        }
        return this.createRecord();
    }

    @Nullable
    private R createRecord() {
        if (this.myPathsParser.getErrorText() != null || !this.myOptionsParser.hasCompleteOptionsList()) {
            if (this.myPathsParser.getErrorText() != null) {
                LOG.debug("Creating record was skipped: " + this.myPathsParser.getErrorText());
            }
            if (!this.myOptionsParser.hasCompleteOptionsList()) {
                LOG.debug("Parsed incomplete options " + this.myOptionsParser.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptionsParser.myOptions));
            }
            this.myOptionsParser.clear();
            this.myRecordBuilder.clear();
            this.myPathsParser.clear();
            return null;
        }
        Map<GitLogOption, String> options = this.myOptionsParser.getResult();
        this.myOptionsParser.clear();
        R record = this.myRecordBuilder.build(options, this.mySupportsRawBody);
        this.myRecordBuilder.clear();
        this.myPathsParser.clear();
        this.myIsInBody = true;
        return record;
    }

    public void clear() {
        this.myOptionsParser.clear();
        this.myRecordBuilder.clear();
        this.myIsInBody = true;
    }

    @NotNull
    public String getPretty() {
        return this.myPretty;
    }

    @NotNull
    private String makeFormatFromOptions(GitLogOption @NotNull [] options) {
        Function function = option -> "%" + ((GitLogOption)option).getPlaceholder();
        return GitLogParser.encodeForGit(this.myRecordStart) + StringUtil.join((Object[])options, (Function)function, (String)GitLogParser.encodeForGit(this.myItemsSeparator)) + GitLogParser.encodeForGit(this.myRecordEnd);
    }

    @NotNull
    private static String encodeForGit(@NotNull String line) {
        StringBuilder encoded = new StringBuilder();
        line.chars().forEachOrdered(c -> encoded.append("%x").append(String.format("%02x", c)));
        return encoded.toString();
    }

    @NotNull
    private static String generateRandomSequence() {
        int length = ERROR_COUNT.get() % (10 - RECORD_START.length());
        StringBuilder tail = new StringBuilder();
        for (int i2 = 0; i2 < length; ++i2) {
            int randomIndex = ThreadLocalRandom.current().nextInt(0, CONTROL_CHARS.length);
            tail.append(CONTROL_CHARS[randomIndex]);
        }
        return tail.toString();
    }

    private static void throwGFE(@NotNull String message, @NotNull CharSequence line) {
        ERROR_COUNT.incrementAndGet();
        throw new GitFormatException(message + " [" + GitLogParser.getTruncatedEscapedOutput(line) + "]");
    }

    @NotNull
    private static String getTruncatedEscapedOutput(@NotNull CharSequence line) {
        String formatString = "%s...(%d more characters)...%s";
        String lineString = line.length() > 1000100 + formatString.length() ? String.format(formatString, line.subSequence(0, 1000000), line.length() - 1000000 - 100, line.subSequence(line.length() - 100, line.length())) : line.toString();
        return StringUtil.escapeStringCharacters((String)lineString);
    }

    private static class PartialResult {
        @NotNull
        private List<String> myResult = new ArrayList<String>();
        @NotNull
        private final StringBuilder myCurrentItem = new StringBuilder();

        private PartialResult() {
        }

        public void append(char c) {
            this.myCurrentItem.append(c);
        }

        public void finishItem() {
            this.myResult.add(this.myCurrentItem.toString());
            this.myCurrentItem.setLength(0);
        }

        @NotNull
        public List<String> getResult() {
            return this.myResult;
        }

        public void clear() {
            this.myCurrentItem.setLength(0);
            this.myResult = new ArrayList<String>();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty() && this.myCurrentItem.length() == 0;
        }
    }

    private class MyPathsParser
    extends PathsParser<R> {
        MyPathsParser(NameStatus nameStatusOption) {
            super(nameStatusOption, GitLogParser.this.myRecordBuilder);
        }

        @Override
        @NotNull
        protected String getErrorText(@NotNull CharSequence line) {
            return super.getErrorText(line) + " for record " + GitLogParser.this.myOptionsParser.myResult.getResult();
        }
    }

    public static class PathsParser<R extends GitLogRecord> {
        @NotNull
        private final NameStatus myNameStatusOption;
        @NotNull
        private final GitLogRecordBuilder<R> myRecordBuilder;
        @Nullable
        private String myErrorText = null;

        PathsParser(@NotNull NameStatus nameStatusOption, @NotNull GitLogRecordBuilder<R> recordBuilder) {
            this.myNameStatusOption = nameStatusOption;
            this.myRecordBuilder = recordBuilder;
        }

        public void parseLine(@NotNull CharSequence line) {
            if (line.length() == 0) {
                return;
            }
            List<String> match2 = PathsParser.parsePathsLine(line);
            if (!match2.isEmpty()) {
                if (this.myNameStatusOption != NameStatus.STATUS) {
                    GitLogParser.throwGFE("Status list not expected", line);
                }
                if (match2.size() < 2) {
                    this.myErrorText = this.getErrorText(line);
                } else if (match2.size() == 2) {
                    this.addPath(match2.get(0), match2.get(1), null);
                } else {
                    this.addPath(match2.get(0), match2.get(1), match2.get(2));
                }
            }
        }

        @NotNull
        protected String getErrorText(@NotNull CharSequence line) {
            return "Could not parse status line [" + line + "]";
        }

        private void addPath(@NotNull String type, @NotNull String firstPath, @Nullable String secondPath) {
            this.myRecordBuilder.addPath(GitChangesParser.getChangeType(GitChangeType.fromString(type)), PathsParser.tryUnescapePath(firstPath), PathsParser.tryUnescapePath(secondPath));
        }

        @Nullable
        @Contract(value="!null -> !null")
        private static String tryUnescapePath(@Nullable String path) {
            if (path == null) {
                return null;
            }
            try {
                return GitUtil.unescapePath(path);
            }
            catch (VcsException e) {
                LOG.error((Throwable)e);
                return path;
            }
        }

        @NotNull
        private static List<String> parsePathsLine(@NotNull CharSequence line) {
            PartialResult result2 = new PartialResult();
            for (int offset = 0; offset < line.length() && !PathsParser.atLineEnd(line, offset); ++offset) {
                char charAt = line.charAt(offset);
                if (charAt == '\t') {
                    result2.finishItem();
                    continue;
                }
                result2.append(charAt);
            }
            result2.finishItem();
            return result2.getResult();
        }

        private static boolean atLineEnd(@NotNull CharSequence line, int offset) {
            while (offset < line.length() && line.charAt(offset) == '\t') {
                ++offset;
            }
            return offset == line.length() || line.charAt(offset) == '\n' || line.charAt(offset) == '\r';
        }

        public boolean expectsPaths() {
            return this.myNameStatusOption == NameStatus.STATUS;
        }

        public void clear() {
            this.myErrorText = null;
        }

        @Nullable
        public String getErrorText() {
            return this.myErrorText;
        }
    }

    private class OptionsParser {
        private final GitLogOption @NotNull [] myOptions;
        @NotNull
        private final PartialResult myResult = new PartialResult();

        OptionsParser(GitLogOption[] options) {
            this.myOptions = options;
        }

        public boolean parseLine(@NotNull CharSequence line) {
            int offset = 0;
            if (this.myResult.isEmpty()) {
                if (!CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordStart)) {
                    return false;
                }
                offset += GitLogParser.this.myRecordStart.length();
            }
            while (offset < line.length()) {
                if (this.atRecordEnd(line, offset)) {
                    this.myResult.finishItem();
                    if (!this.hasCompleteOptionsList()) {
                        GitLogParser.throwGFE("Parsed incomplete options " + this.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptions), line);
                    }
                    return true;
                }
                if (CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myItemsSeparator)) {
                    this.myResult.finishItem();
                    offset += GitLogParser.this.myItemsSeparator.length();
                    continue;
                }
                char c = line.charAt(offset);
                this.myResult.append(c);
                ++offset;
            }
            this.myResult.append('\n');
            return false;
        }

        public boolean hasCompleteOptionsList() {
            return this.myResult.getResult().size() == this.myOptions.length;
        }

        private boolean atRecordEnd(@NotNull CharSequence line, int offset) {
            return offset == line.length() - GitLogParser.this.myRecordEnd.length() && CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordEnd);
        }

        @NotNull
        public Map<GitLogOption, String> getResult() {
            return this.createOptions(this.myResult.getResult());
        }

        @NotNull
        private Map<GitLogOption, String> createOptions(@NotNull List<String> options) {
            HashMap<GitLogOption, String> optionsMap = new HashMap<GitLogOption, String>(options.size());
            for (int index = 0; index < options.size(); ++index) {
                optionsMap.put(this.myOptions[index], options.get(index));
            }
            return optionsMap;
        }

        public void clear() {
            this.myResult.clear();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty();
        }
    }

    static enum GitLogOption {
        HASH("H"),
        TREE("T"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private final String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        STATUS;

    }
}

