/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitLogFullRecord
extends GitLogRecord {
    @NotNull
    private final List<? extends VcsFileStatusInfo> myStatusInfo;

    GitLogFullRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, @NotNull List<? extends VcsFileStatusInfo> statusInfo, boolean supportsRawBody) {
        super(options, supportsRawBody);
        this.myStatusInfo = statusInfo;
    }

    @NotNull
    private Collection<String> getPaths() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (VcsFileStatusInfo vcsFileStatusInfo : this.myStatusInfo) {
            result2.add(vcsFileStatusInfo.getFirstPath());
            if (vcsFileStatusInfo.getSecondPath() == null) continue;
            result2.add(vcsFileStatusInfo.getSecondPath());
        }
        return result2;
    }

    @NotNull
    List<? extends VcsFileStatusInfo> getStatusInfos() {
        return this.myStatusInfo;
    }

    @NotNull
    List<FilePath> getFilePaths(@NotNull VirtualFile root) {
        ArrayList<FilePath> res = new ArrayList<FilePath>();
        String prefix = root.getPath() + "/";
        for (String strPath : this.getPaths()) {
            res.add(VcsUtil.getFilePath((String)(prefix + strPath), (boolean)false));
        }
        return res;
    }

    @NotNull
    List<Change> parseChanges(@NotNull Project project, @NotNull VirtualFile vcsRoot) throws VcsException {
        String[] hashes2 = this.getParentsHashes();
        return GitChangesParser.parse(project, vcsRoot, this.myStatusInfo, this.getHash(), this.getDate(), hashes2.length == 0 ? null : hashes2[0]);
    }

    @Override
    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, myStatusInfo=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.myStatusInfo, this.mySupportsRawBody, this.myHandler);
    }
}

