/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogUtil;
import git4idea.history.browser.SHAHash;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    private static final Logger LOG = Logger.getInstance(GitHistoryUtils.class);

    private GitHistoryUtils() {
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super GitCommit> commitConsumer, String ... parameters) throws VcsException {
        GitLogUtil.readFullDetails(project, root, commitConsumer, parameters);
    }

    public static void loadTimedCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super TimedVcsCommit> commitConsumer, String ... parameters) throws VcsException {
        GitLogUtil.readTimedCommits(project, root, Arrays.asList(parameters), null, null, commitConsumer);
    }

    public static List<? extends TimedVcsCommit> collectTimedCommits(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        ArrayList commits2 = new ArrayList();
        GitHistoryUtils.loadTimedCommits(project, root, (Consumer<? super TimedVcsCommit>)((Consumer)commits2::add), parameters);
        return commits2;
    }

    @Nullable
    public static List<? extends VcsCommitMetadata> collectCommitsMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... hashes2) throws VcsException {
        List<? extends VcsCommitMetadata> result2 = GitLogUtil.collectMetadata(project, GitVcs.getInstance(project), root, Arrays.asList(hashes2));
        if (result2.size() != hashes2.length) {
            return null;
        }
        return result2;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        VcsLogObjectsFactory factory = GitLogUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return Collections.emptyList();
        }
        ArrayList<GitCommit> commits2 = new ArrayList<GitCommit>();
        try {
            GitLogUtil.readFullDetails(project, root, (Consumer<? super GitCommit>)((Consumer)commits2::add), parameters);
        }
        catch (VcsException e) {
            if (commits2.isEmpty()) {
                throw e;
            }
            LOG.warn("Error during loading details, returning partially loaded commits\n", (Throwable)e);
        }
        return commits2;
    }

    public static String @NotNull [] formHashParameters(@NotNull GitVcs vcs, @NotNull Collection<String> hashes2) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(GitLogUtil.getNoWalkParameter(vcs));
        parameters.addAll(hashes2);
        return ArrayUtilRt.toStringArray(parameters);
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h2 = new GitLineHandler(project, GitUtil.getRootForFile(project, filePath), GitCommand.LOG);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h2.setSilent(true);
        h2.addParameters("-n1", parser.getPretty());
        h2.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h2);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h2 = new GitLineHandler(project, GitUtil.getRootForFile(project, filePath), GitCommand.LOG);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h2.setSilent(true);
        h2.addParameters("-n1", parser.getPretty());
        h2.addParameters("--encoding=UTF-8");
        h2.addParameters("--all");
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h2);
        String author = Objects.equals(record.getAuthorName(), record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        GitRepository repository = GitUtil.getRepositoryForFile(project, filePath);
        VirtualFile root = repository.getRoot();
        GitLocalBranch c = repository.getCurrentBranch();
        GitBranchTrackInfo info = c == null ? null : repository.getBranchTrackInfo(c.getName());
        GitRemoteBranch gitRemoteBranch = t = info == null ? null : info.getRemoteBranch();
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)filePath);
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser<GitLogFullRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h2.setSilent(true);
        h2.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h2.endOptions();
        h2.addRelativePaths(filePath);
        String result2 = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        if (result2.length() == 0) {
            return null;
        }
        GitLogFullRecord record = parser.parseOneRecord(result2);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h2);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.MERGE_BASE);
        h2.setSilent(true);
        h2.addParameters(first, second);
        GitCommandResult result2 = Git.getInstance().runCommand(h2);
        if (!result2.success()) {
            return null;
        }
        String output = result2.getOutputAsJoinedString().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    public static long getAuthorTime(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commitsId) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.SHOW);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.AUTHOR_TIME);
        h2.setSilent(true);
        h2.addParameters("-s", parser.getPretty(), "--encoding=UTF-8");
        h2.addParameters(commitsId);
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        GitLogRecord logRecord = parser.parseOneRecord(output);
        if (logRecord == null) {
            throw new VcsException("Can not parse log output \"" + output + "\"");
        }
        return logRecord.getAuthorTimeStamp();
    }

    @Deprecated
    @NotNull
    public static FilePath getLastCommitName(@NotNull Project project, @NotNull FilePath path) {
        return VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        VirtualFile root = GitUtil.getRootForFile(project, path);
        return GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        path = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser<GitLogRecord> parser = GitLogParser.createDefaultParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h2.setStdoutSuppressed(true);
        h2.addParameters(parameters);
        h2.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h2.endOptions();
        h2.addRelativePaths(path);
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h2);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        return rc;
    }

    @Deprecated
    public static List<? extends VcsCommitMetadata> readLastCommits(@NotNull Project project, @NotNull VirtualFile root, String ... hashes2) throws VcsException {
        return GitHistoryUtils.collectCommitsMetadata(project, root, hashes2);
    }
}

