/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ThreeState;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.CachingFileTester;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.nio.file.NoSuchFileException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitExecutableDetector myExecutableDetector = new GitExecutableDetector();
    @NotNull
    private final CachingFileTester<GitVersion> myVersionCache = new CachingFileTester<GitVersion>(){

        @Override
        @NotNull
        protected GitVersion testExecutable(@NotNull GitExecutable executable) throws VcsException, ParseException {
            return GitExecutableManager.doGetGitVersion(executable);
        }
    };

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ServiceManager.getService(GitExecutableManager.class);
    }

    private static GitVersion doGetGitVersion(@NotNull GitExecutable executable) throws VcsException, ParseException {
        GitVersion.Type type = null;
        if (executable instanceof GitExecutable.Unknown) {
            type = GitVersion.Type.UNDEFINED;
        } else if (executable instanceof GitExecutable.Wsl) {
            WSLDistribution distribution = ((GitExecutable.Wsl)executable).getDistribution();
            type = WSLUtil.isWsl1((WSLDistribution)distribution) == ThreeState.YES ? GitVersion.Type.WSL1 : GitVersion.Type.WSL2;
        }
        LOG.debug("Acquiring git version for " + executable);
        GitLineHandler handler = new GitLineHandler(null, new File("."), executable, GitCommand.VERSION, Collections.emptyList());
        handler.setPreValidateExecutable(false);
        handler.setSilent(false);
        handler.setTerminationTimeout(1000);
        handler.setStdoutSuppressed(false);
        GitCommandResult result2 = Git.getInstance().runCommand(handler);
        String rawResult = result2.getOutputOrThrow(new int[0]);
        GitVersion version = GitVersion.parse(rawResult, type);
        LOG.info("Git version for " + executable + ": " + version.toString());
        return version;
    }

    @NotNull
    public String getPathToGit() {
        return this.getPathToGit(null);
    }

    @NotNull
    public String getPathToGit(@Nullable Project project) {
        String pathToGit = this.getPathToGit(project, true);
        if (pathToGit == null) {
            pathToGit = GitExecutableDetector.getDefaultExecutable();
        }
        return pathToGit;
    }

    @Nullable
    private String getPathToGit(@Nullable Project project, boolean detectIfNeeded) {
        String path;
        String string = path = project != null ? GitVcsSettings.getInstance(project).getPathToGit() : null;
        if (path == null) {
            path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        }
        if (path == null) {
            path = this.getDetectedExecutable(project, detectIfNeeded);
        }
        return path;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project) {
        String path = this.getPathToGit(project);
        return this.getExecutable(path);
    }

    @NotNull
    public GitExecutable getExecutable(@NotNull String pathToGit) {
        Pair<String, WSLDistribution> pair = GitExecutableManager.parseWslPath(pathToGit);
        if (pair != null) {
            if (pair.second != null) {
                return new GitExecutable.Wsl((String)pair.first, (WSLDistribution)pair.second);
            }
            return new GitExecutable.Unknown("wsl-unknown", (String)pair.first, GitBundle.message("git.executable.unknown.wsl.distribution.error.message", new Object[0]));
        }
        return new GitExecutable.Local(pathToGit);
    }

    public static boolean supportWslExecutable() {
        return WSLUtil.isSystemCompatible() && Experiments.getInstance().isFeatureEnabled("wsl.p9.show.roots.in.file.chooser");
    }

    @Nullable
    private static WSLDistribution getProjectWslDistribution(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        Pair<String, WSLDistribution> pair = GitExecutableManager.parseWslPath(FileUtil.toSystemDependentName((String)basePath));
        return pair != null ? (WSLDistribution)pair.second : null;
    }

    @Nullable
    private static @Nullable Pair<String, @Nullable WSLDistribution> parseWslPath(@NotNull String path) {
        if (!GitExecutableManager.supportWslExecutable()) {
            return null;
        }
        if (!path.startsWith("\\\\wsl$\\")) {
            return null;
        }
        int index = (path = StringUtil.trimStart((String)path, (String)"\\\\wsl$\\")).indexOf(92);
        if (index == -1) {
            return null;
        }
        String distName = path.substring(0, index);
        String wslPath = FileUtil.toSystemIndependentName((String)path.substring(index));
        WSLDistribution distribution = WSLUtil.getDistributionByMsId((String)distName);
        if (distribution == null) {
            LOG.debug(String.format("Unknown WSL distribution: %s, known distributions: %s", distName, StringUtil.join((Collection)WSLUtil.getAvailableDistributions(), WSLDistribution::getMsId, (String)", ")));
        }
        return Pair.create((Object)wslPath, (Object)distribution);
    }

    @NotNull
    public String getDetectedExecutable(@Nullable Project project) {
        String executable = this.getDetectedExecutable(project, true);
        return executable != null ? executable : GitExecutableDetector.getDefaultExecutable();
    }

    @Nullable
    private String getDetectedExecutable(@Nullable Project project, boolean detectIfNeeded) {
        WSLDistribution distribution = GitExecutableManager.getProjectWslDistribution(project);
        if (detectIfNeeded) {
            return this.myExecutableDetector.detect(distribution);
        }
        return this.myExecutableDetector.getExecutable(distribution);
    }

    public void dropExecutableCache() {
        this.myExecutableDetector.clear();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String pathToGit = this.getPathToGit(project, false);
        if (pathToGit == null) {
            return GitVersion.NULL;
        }
        GitExecutable executable = this.getExecutable(pathToGit);
        return this.getVersion(executable);
    }

    @NotNull
    public GitVersion getVersion(@NotNull GitExecutable executable) {
        CachingFileTester.TestResult result2 = this.myVersionCache.getCachedResultFor(executable);
        if (result2 == null || result2.getResult() == null) {
            return GitVersion.NULL;
        }
        return (GitVersion)result2.getResult();
    }

    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        return (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            GitExecutable executable = this.getExecutable(project);
            try {
                version = this.identifyVersion(executable);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.getString("git.executable.version.progress.title"), true, project);
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.getString("git.executable.version.progress.title"), () -> {
            try {
                GitExecutable executable = this.getExecutable(project);
                return this.identifyVersion(executable);
            }
            catch (ProcessCanceledException e) {
                return null;
            }
            catch (GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    static <T> T runUnderProgressIfNeeded(@Nullable Project project, @NotNull String title, @NotNull ThrowableComputable<T, RuntimeException> task2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task2, title, true, project);
        }
        return (T)task2.compute();
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        return this.identifyVersion(this.getExecutable(pathToGit));
    }

    @NotNull
    public GitVersion identifyVersion(@NotNull GitExecutable executable) throws GitVersionIdentificationException {
        CachingFileTester.TestResult result2 = this.myVersionCache.getResultFor(executable);
        if (result2.getResult() == null) {
            Exception e = result2.getException();
            if (e instanceof NoSuchFileException && executable.getExePath().equals(GitExecutableDetector.getDefaultExecutable())) {
                throw new GitNotInstalledException(GitBundle.message("executable.error.git.not.installed", new Object[0]), e);
            }
            throw new GitVersionIdentificationException(GitBundle.message("git.executable.validation.cant.identify.executable.message", executable), e);
        }
        return (GitVersion)result2.getResult();
    }

    public void dropVersionCache(@NotNull GitExecutable executable) {
        this.myVersionCache.dropCache(executable);
    }

    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        GitExecutable executable = this.getExecutable(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, executable);
        if (version == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull GitExecutable executable) {
        try {
            return this.identifyVersion(executable);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }
}

