/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.util.Ref;
import git4idea.config.GitExecutable;
import git4idea.config.GitVersionIdentificationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CachingFileTester<T> {
    private static final Logger LOG = Logger.getInstance(CachingFileTester.class);
    private static final int FILE_TEST_TIMEOUT_MS = 30000;
    private final ReentrantLock LOCK = new ReentrantLock();
    @NotNull
    private final ConcurrentMap<GitExecutable, TestResult> myTestMap = new ConcurrentHashMap<GitExecutable, TestResult>();

    CachingFileTester() {
    }

    @NotNull
    final TestResult getResultFor(@NotNull GitExecutable executable) {
        return (TestResult)ProgressIndicatorUtils.computeWithLockAndCheckingCanceled((Lock)this.LOCK, (int)50, (TimeUnit)TimeUnit.MILLISECONDS, () -> {
            TestResult result2 = (TestResult)this.myTestMap.get(executable);
            long currentLastModificationDate = 0L;
            try {
                currentLastModificationDate = CachingFileTester.getModificationTime(executable);
                if (result2 == null || result2.getFileLastModifiedTimestamp() != currentLastModificationDate) {
                    result2 = new TestResult(this.testOrAbort(executable), currentLastModificationDate);
                    this.myTestMap.put(executable, result2);
                }
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Exception e) {
                result2 = new TestResult(e, currentLastModificationDate);
                this.myTestMap.put(executable, result2);
            }
            return result2;
        });
    }

    private static long getModificationTime(@NotNull GitExecutable executable) throws IOException {
        if (executable instanceof GitExecutable.Unknown) {
            return 0L;
        }
        if (executable instanceof GitExecutable.Local) {
            File exeFile;
            String filePath = executable.getExePath();
            if (!filePath.contains(File.separator) && (exeFile = PathEnvironmentVariableUtil.findInPath((String)filePath)) != null) {
                filePath = exeFile.getPath();
            }
            return Files.getLastModifiedTime(Paths.get(filePath, new String[0]), new LinkOption[0]).toMillis();
        }
        if (executable instanceof GitExecutable.Wsl) {
            return 0L;
        }
        LOG.error("Can't get modification time for " + executable);
        return 0L;
    }

    @NotNull
    private T testOrAbort(@NotNull GitExecutable executable) throws Exception {
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        Ref exceptionRef = new Ref();
        Ref resultRef = new Ref();
        Semaphore semaphore = new Semaphore(0);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                resultRef.set(this.testExecutable(executable));
            }
            catch (Exception e) {
                exceptionRef.set((Object)e);
            }
            finally {
                semaphore.release();
            }
        }, (ProgressIndicator)indicator));
        try {
            long start = System.currentTimeMillis();
            do {
                ProgressManager.checkCanceled();
            } while (!semaphore.tryAcquire(50L, TimeUnit.MILLISECONDS) && System.currentTimeMillis() - start <= 30000L);
            if (!resultRef.isNull()) {
                Object object = resultRef.get();
                return (T)object;
            }
            if (!exceptionRef.isNull()) {
                throw (Exception)exceptionRef.get();
            }
            throw new GitVersionIdentificationException("Cannot identify version of git executable: no response", null);
        }
        finally {
            indicator.cancel();
        }
    }

    @Nullable
    public TestResult getCachedResultFor(@NotNull GitExecutable executable) {
        return (TestResult)this.myTestMap.get(executable);
    }

    public void dropCache(@NotNull GitExecutable executable) {
        this.myTestMap.remove(executable);
    }

    @NotNull
    protected abstract T testExecutable(@NotNull GitExecutable var1) throws Exception;

    class TestResult {
        @Nullable
        private final T myResult;
        @Nullable
        private final Exception myException;
        private final long myFileLastModifiedTimestamp;

        TestResult(T result2, long timestamp) {
            this.myResult = result2;
            this.myFileLastModifiedTimestamp = timestamp;
            this.myException = null;
        }

        TestResult(Exception exception, long timestamp) {
            this.myFileLastModifiedTimestamp = timestamp;
            this.myResult = null;
            this.myException = exception;
        }

        @Nullable
        public T getResult() {
            return this.myResult;
        }

        @Nullable
        public Exception getException() {
            return this.myException;
        }

        private long getFileLastModifiedTimestamp() {
            return this.myFileLastModifiedTimestamp;
        }
    }
}

