/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SSHUtil;
import com.intellij.util.PathUtil;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitNativeSshAuthenticator;
import git4idea.commands.GitSSHGUIHandler;
import git4idea.i18n.GitBundle;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitNativeSshGuiAuthenticator
implements GitNativeSshAuthenticator {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GitAuthenticationGate myAuthenticationGate;
    @NotNull
    private final GitAuthenticationMode myAuthenticationMode;
    private final boolean myDoNotRememberPasswords;
    @Nullable
    private String myLastAskedKeyPath = null;
    @Nullable
    private String myLastAskedUserName = null;
    @Nullable
    private String myLastAskedConfirmationInput = null;

    GitNativeSshGuiAuthenticator(@NotNull Project project, @NotNull GitAuthenticationGate authenticationGate, @NotNull GitAuthenticationMode authenticationMode, boolean doNotRememberPasswords) {
        this.myProject = project;
        this.myAuthenticationGate = authenticationGate;
        this.myAuthenticationMode = authenticationMode;
        this.myDoNotRememberPasswords = doNotRememberPasswords;
    }

    @Override
    @Nullable
    public String handleInput(@NotNull String description) {
        if (this.myAuthenticationMode == GitAuthenticationMode.NONE) {
            return null;
        }
        return this.myAuthenticationGate.waitAndCompute(() -> {
            if (GitNativeSshGuiAuthenticator.isKeyPassphrase(description)) {
                return this.askKeyPassphraseInput(description);
            }
            if (GitNativeSshGuiAuthenticator.isSshPassword(description)) {
                return this.askSshPasswordInput(description);
            }
            if (GitNativeSshGuiAuthenticator.isConfirmation(description)) {
                return this.askConfirmationInput(description);
            }
            return this.askGenericInput(description);
        });
    }

    private static boolean isKeyPassphrase(@NotNull String description) {
        return SSHUtil.PASSPHRASE_PROMPT.matcher(description).matches();
    }

    @Nullable
    private String askKeyPassphraseInput(@NotNull String description) {
        Matcher matcher = SSHUtil.PASSPHRASE_PROMPT.matcher(description);
        if (!matcher.matches()) {
            throw new IllegalStateException(description);
        }
        String keyPath = matcher.group(1);
        boolean resetPassword = keyPath.equals(this.myLastAskedKeyPath);
        this.myLastAskedKeyPath = keyPath;
        if (this.myDoNotRememberPasswords) {
            return this.askUser((Computable<String>)((Computable)() -> {
                String message = GitBundle.message("ssh.ask.passphrase.message", PathUtil.getFileName((String)keyPath));
                return Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)GitBundle.getString("ssh.ask.passphrase.title"), null);
            }));
        }
        return GitSSHGUIHandler.askPassphrase(this.myProject, keyPath, resetPassword, this.myAuthenticationMode, null);
    }

    private static boolean isSshPassword(@NotNull String description) {
        return SSHUtil.PASSWORD_PROMPT.matcher(description).matches();
    }

    @Nullable
    private String askSshPasswordInput(@NotNull String description) {
        Matcher matcher = SSHUtil.PASSWORD_PROMPT.matcher(description);
        if (!matcher.matches()) {
            throw new IllegalStateException(description);
        }
        String username = matcher.group(1);
        boolean resetPassword = username.equals(this.myLastAskedUserName);
        this.myLastAskedUserName = username;
        if (this.myDoNotRememberPasswords) {
            return this.askUser((Computable<String>)((Computable)() -> {
                String message = GitBundle.message("ssh.password.message", username);
                return Messages.showPasswordDialog((Project)this.myProject, (String)message, (String)GitBundle.getString("ssh.password.title"), null);
            }));
        }
        return GitSSHGUIHandler.askPassword(this.myProject, username, resetPassword, this.myAuthenticationMode, null);
    }

    private static boolean isConfirmation(@NotNull String description) {
        return description.contains("Are you sure you want to continue connecting");
    }

    @Nullable
    private String askConfirmationInput(@NotNull String description) {
        return this.askUser((Computable<String>)((Computable)() -> {
            String textAnswer;
            String message = StringUtil.replace((String)description, (String)"Are you sure you want to continue connecting (yes/no)?", (String)"Are you sure you want to continue connecting?");
            String knownAnswer = this.myAuthenticationGate.getSavedInput(message);
            if (knownAnswer != null && this.myLastAskedConfirmationInput == null) {
                this.myLastAskedConfirmationInput = knownAnswer;
                return knownAnswer;
            }
            int answer = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)"SSH Confirmation", null);
            if (answer == 0) {
                textAnswer = "yes";
            } else if (answer == 1) {
                textAnswer = "no";
            } else {
                throw new AssertionError(answer);
            }
            this.myAuthenticationGate.saveInput(message, textAnswer);
            return textAnswer;
        }));
    }

    @Nullable
    private String askGenericInput(@NotNull String description) {
        return this.askUser((Computable<String>)((Computable)() -> Messages.showPasswordDialog((Project)this.myProject, (String)description, (String)GitBundle.message("ssh.keyboard.interactive.title", new Object[0]), null)));
    }

    @Nullable
    private String askUser(@NotNull Computable<String> query) {
        if (this.myAuthenticationMode != GitAuthenticationMode.FULL) {
            return null;
        }
        Ref answerRef = new Ref();
        ApplicationManager.getApplication().invokeAndWait(() -> answerRef.set(query.compute()), ModalityState.any());
        return (String)answerRef.get();
    }
}

