/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class GitDeleteTagOperation
extends GitBranchOperation {
    @NotNull
    private final String myTagName;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final Map<GitRepository, String> myDeletedTagTips = new HashMap<GitRepository, String>();

    GitDeleteTagOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String tagName) {
        super(project, git, uiHandler, repositories);
        this.myTagName = tagName;
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    @Override
    public void execute() {
        for (GitRepository repository : this.getRepositories()) {
            try {
                GitRevisionNumber revisionNumber = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "refs/tags/" + this.myTagName);
                this.myDeletedTagTips.put(repository, revisionNumber.asString());
            }
            catch (VcsException e) {
                String title = !GitUtil.justOneGitRepository(this.myProject) ? GitBundle.message("delete.tag.operation.could.not.find.tag.in", repository.getPresentableUrl()) : GitBundle.message("delete.tag.operation.could.not.find.tag", this.myTagName);
                this.fatalError(title, "");
                return;
            }
        }
        while (this.hasMoreRepositories()) {
            GitRepository repository = this.next();
            GitCommandResult result2 = this.myGit.deleteTag(repository, this.myTagName, new GitLineHandlerListener[0]);
            if (result2.success()) {
                repository.getRepositoryFiles().refreshTagsFiles();
                this.markSuccessful(repository);
                continue;
            }
            this.fatalError(GitBundle.message("delete.tag.operation.tag.was.not.deleted", this.myTagName), result2.getErrorOutputAsJoinedString());
            return;
        }
        this.notifySuccess();
    }

    @Override
    protected void notifySuccess() {
        String message = GitBundle.message("delete.tag.operation.deleted.tag", this.myTagName);
        Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification("", message, NotificationType.INFORMATION, null);
        notification.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.GitDeleteTagOperation.text.restore", new Object[0]), () -> this.restoreInBackground(notification)));
        int remotes = 0;
        for (GitRepository repository : this.getRepositories()) {
            remotes += repository.getRemotes().size();
        }
        if (remotes > 0) {
            String text = GitBundle.message("delete.tag.operation.delete.on.remote", remotes);
            notification.addAction((AnAction)NotificationAction.createSimple((String)text, () -> this.pushRemotesInBackground()));
        }
        this.myNotifier.notify(notification);
    }

    private void restoreInBackground(final @NotNull Notification notification) {
        new Task.Backgroundable(this.myProject, GitBundle.message("delete.tag.operation.restoring.tag.process", this.myTagName)){

            public void run(@NotNull ProgressIndicator indicator) {
                GitDeleteTagOperation.this.rollbackTagDeletion(notification);
            }
        }.queue();
    }

    @Override
    protected void rollback() {
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(GitBundle.message("delete.tag.operation.rollback.successful", new Object[0]), GitBundle.message("delete.tag.operation.restored.tag", this.myTagName), NotificationType.INFORMATION, null);
            this.myNotifier.notify(notification);
        } else {
            this.myNotifier.notifyError(GitBundle.message("delete.tag.operation.error.during.rollback.of.tag.deletion", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    private void rollbackTagDeletion(@NotNull Notification notification) {
        GitCompoundResult result2 = this.doRollback();
        if (result2.totalSuccess()) {
            notification.expire();
        } else {
            this.myNotifier.notifyError(GitBundle.message("delete.tag.operation.could.not.restore.tag", GitUIUtil.bold(GitUIUtil.code(this.myTagName))), result2.getErrorOutputWithReposIndication(), true);
        }
    }

    @NotNull
    private GitCompoundResult doRollback() {
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            GitCommandResult res = this.myGit.createNewTag(repository, this.myTagName, null, this.myDeletedTagTips.get(repository));
            result2.append(repository, res);
            repository.getRepositoryFiles().refreshTagsFiles();
        }
        return result2;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return GitBundle.message("delete.tag.operation.however.tag.deletion.has.succeeded.for.the.following", this.getSkippedRepositories().size()) + "<br/>" + this.successfulRepositoriesJoined() + "<br/>" + GitBundle.message("delete.tag.operation.you.may.rollback.not.to.let.tags.diverge", this.myTagName);
    }

    @Override
    @NotNull
    protected String getOperationName() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        throw new UnsupportedOperationException();
    }

    private void pushRemotesInBackground() {
        GitBrancher.getInstance(this.myProject).deleteRemoteTag(this.myTagName, ContainerUtil.map2Map(this.getRepositories(), it -> Pair.create((Object)it, (Object)this.myDeletedTagTips.get(it))));
    }
}

