/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.VcsSynchronousProgressWrapper;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitRevisionNumber;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitRepositoryForAnnotationsListener;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableValidator;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.status.GitChangeProvider;
import git4idea.update.GitUpdateEnvironment;
import git4idea.util.GitVcsConsoleWriter;
import git4idea.vfs.GitVFSListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitVcs
extends AbstractVcs {
    public static final String NAME = "Git";
    public static final String ID = "git";
    private static final Logger LOG = Logger.getInstance((String)GitVcs.class.getName());
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    private Disposable myDisposable;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock = new ReentrantReadWriteLock(true);

    @NotNull
    public static GitVcs getInstance(@NotNull Project project) {
        GitVcs gitVcs = (GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
        ProgressManager.checkCanceled();
        return Objects.requireNonNull(gitVcs);
    }

    public GitVcs(@NotNull Project project) {
        super(project, NAME);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task2) {
        task2.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return (CommittedChangesProvider)this.myProject.getService(GitCommittedChangeListProvider.class);
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @Nullable
    public CheckinEnvironment getCheckinEnvironment() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return (CheckinEnvironment)this.myProject.getService(GitCheckinEnvironment.class);
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        return GitMergeProvider.detect(this.myProject);
    }

    @NotNull
    public RollbackEnvironment getRollbackEnvironment() {
        return (RollbackEnvironment)this.myProject.getService(GitRollbackEnvironment.class);
    }

    @NotNull
    public GitHistoryProvider getVcsHistoryProvider() {
        return (GitHistoryProvider)this.myProject.getService(GitHistoryProvider.class);
    }

    public GitHistoryProvider getVcsBlockHistoryProvider() {
        return (GitHistoryProvider)this.myProject.getService(GitHistoryProvider.class);
    }

    @NotNull
    public String getDisplayName() {
        return NAME;
    }

    @Nullable
    public UpdateEnvironment getUpdateEnvironment() {
        return (UpdateEnvironment)this.myProject.getService(GitUpdateEnvironment.class);
    }

    @NotNull
    public AnnotationProviderEx getAnnotationProvider() {
        return (AnnotationProviderEx)this.myProject.getService(GitAnnotationProvider.class);
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        return (DiffProvider)this.myProject.getService(GitDiffProvider.class);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getRootForFile(this.myProject, path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                LOG.info("Unexpected problem with resolving the git revision number: ", (Throwable)e);
                throw e;
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.isUnderGit(dir);
    }

    protected void activate() {
        this.myDisposable = Disposer.newDisposable();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myDisposable, () -> GitExecutableManager.getInstance().testGitExecutableVersionValid(this.myProject));
        if (this.myVFSListener == null) {
            this.myVFSListener = GitVFSListener.createInstance(this);
        }
        ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        GitRepositoryForAnnotationsListener.registerListener(this.myProject, this.myDisposable);
        GitUserRegistry.getInstance(this.myProject).activate();
        GitBranchIncomingOutgoingManager.getInstance(this.myProject).activate();
    }

    protected void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myDisposable = null;
        }
    }

    public Configurable getConfigurable() {
        return null;
    }

    @Nullable
    public GitChangeProvider getChangeProvider() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return (GitChangeProvider)this.myProject.getService(GitChangeProvider.class);
    }

    public void showErrors(@NotNull List<? extends VcsException> list, @NotNull String action) {
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException vcsException : list) {
                buffer.append("\n");
                buffer.append(vcsException.getMessage());
            }
            String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title")));
        }
    }

    @NotNull
    public GitVersion getVersion() {
        return GitExecutableManager.getInstance().getVersion(this.myProject);
    }

    @Deprecated
    public void showCommandLine(String cmdLine) {
        GitVcsConsoleWriter.getInstance(this.myProject).showCommandLine(cmdLine);
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return (VcsOutgoingChangesProvider)this.myProject.getService(GitOutgoingChangesProvider.class);
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public List<CommitExecutor> getCommitExecutors() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.myProject.getService(GitCommitAndPushExecutor.class));
    }

    @Deprecated
    @NotNull
    public GitExecutableValidator getExecutableValidator() {
        return new GitExecutableValidator(this.myProject);
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public void enableIntegration() {
        new Task.Backgroundable(this.myProject, GitBundle.message("progress.title.enabling.git", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class)).detect();
                new GitIntegrationEnabler(GitVcs.this).enable(roots);
            }
        }.queue();
    }

    public CheckoutProvider getCheckoutProvider() {
        return new GitCheckoutProvider();
    }

    @Nullable
    public CommittedChangeList loadRevisions(@NotNull VirtualFile vf, @NotNull VcsRevisionNumber number) {
        GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(vf);
        if (repository == null) {
            return null;
        }
        return (CommittedChangeList)VcsSynchronousProgressWrapper.compute(() -> GitCommittedChangeListProvider.getCommittedChangeList(this.myProject, repository.getRoot(), (GitRevisionNumber)number), (Project)this.getProject(), (String)"Load Revision Contents");
    }

    public boolean arePartialChangelistsSupported() {
        return true;
    }

    public GitVFSListener getVFSListener() {
        return this.myVFSListener;
    }

    public boolean needsCaseSensitiveDirtyScope() {
        return true;
    }
}

