/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ui.browser.BulkMovesOnlyChangesFilter;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBulkMovesOnlyChangesFilter
implements BulkMovesOnlyChangesFilter {
    private static final Logger LOG = Logger.getInstance(GitBulkMovesOnlyChangesFilter.class);

    @Nullable
    public Collection<Change> filter(@Nullable Project project, @NotNull List<Change> changes) {
        try {
            if (project == null) {
                return null;
            }
            MultiMap revisionMap = MultiMap.createSet();
            for (Change change : changes) {
                if (!GitBulkMovesOnlyChangesFilter.putRevision(project, (MultiMap<Pair<GitRevisionNumber, VirtualFile>, FilePath>)revisionMap, change.getBeforeRevision())) {
                    return null;
                }
                if (GitBulkMovesOnlyChangesFilter.putRevision(project, (MultiMap<Pair<GitRevisionNumber, VirtualFile>, FilePath>)revisionMap, change.getAfterRevision())) continue;
                return null;
            }
            ProgressManager.checkCanceled();
            HashMap<Pair<GitRevisionNumber, FilePath>, String> blobs = new HashMap<Pair<GitRevisionNumber, FilePath>, String>();
            for (Pair key : revisionMap.keySet()) {
                GitRevisionNumber revision = (GitRevisionNumber)key.getFirst();
                VirtualFile root = (VirtualFile)key.getSecond();
                Collection filePaths = revisionMap.get((Object)key);
                GitRepository repository = GitUtil.getRepositoryForRoot(project, root);
                List<GitIndexUtil.StagedFileOrDirectory> treeEntries = GitIndexUtil.listTree(repository, filePaths, (VcsRevisionNumber)revision);
                if (treeEntries.size() != filePaths.size()) {
                    throw new VcsException("Unexpected tree entries: " + revision);
                }
                for (GitIndexUtil.StagedFileOrDirectory entry : treeEntries) {
                    if (entry instanceof GitIndexUtil.StagedFile) {
                        String hash = ((GitIndexUtil.StagedFile)entry).getBlobHash();
                        blobs.put((Pair<GitRevisionNumber, FilePath>)Pair.create((Object)revision, (Object)entry.getPath()), hash);
                        continue;
                    }
                    throw new VcsException("Unexpected tree object: " + entry);
                }
            }
            ProgressManager.checkCanceled();
            ArrayList<Change> arrayList = new ArrayList<Change>();
            for (Change change : changes) {
                if (!GitBulkMovesOnlyChangesFilter.acceptChange(blobs, change)) continue;
                arrayList.add(change);
            }
            return arrayList;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static boolean putRevision(@NotNull Project project, @NotNull MultiMap<Pair<GitRevisionNumber, VirtualFile>, FilePath> map2, @Nullable ContentRevision revision) {
        if (revision == null) {
            return true;
        }
        if (!(revision instanceof GitContentRevision)) {
            return false;
        }
        FilePath filePath = revision.getFile();
        GitRevisionNumber number = (GitRevisionNumber)revision.getRevisionNumber();
        VcsRoot vcsRoot = ProjectLevelVcsManager.getInstance((Project)project).getVcsRootObjectFor(filePath);
        if (vcsRoot == null || vcsRoot.getVcs() == null) {
            return false;
        }
        if (!GitVcs.getKey().equals((Object)vcsRoot.getVcs().getKeyInstanceMethod())) {
            return false;
        }
        map2.putValue((Object)Pair.create((Object)number, (Object)vcsRoot.getPath()), (Object)filePath);
        return true;
    }

    private static boolean acceptChange(@NotNull Map<Pair<GitRevisionNumber, FilePath>, String> blobs, @NotNull Change change) throws VcsException {
        ContentRevision bRev = change.getBeforeRevision();
        ContentRevision aRev = change.getAfterRevision();
        if (bRev == null || aRev == null) {
            return true;
        }
        return !Objects.equals(GitBulkMovesOnlyChangesFilter.findBlob(blobs, bRev), GitBulkMovesOnlyChangesFilter.findBlob(blobs, aRev));
    }

    @NotNull
    private static String findBlob(@NotNull Map<Pair<GitRevisionNumber, FilePath>, String> blobs, @NotNull ContentRevision revision) throws VcsException {
        FilePath filePath = revision.getFile();
        GitRevisionNumber number = (GitRevisionNumber)revision.getRevisionNumber();
        String blob = blobs.get(Pair.create((Object)number, (Object)filePath));
        if (blob == null) {
            throw new VcsException(String.format("Blob not found: %s - %s", number, filePath));
        }
        return blob;
    }
}

