/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class YAMLEnterAtIndentHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement element;
        if (!(file instanceof YAMLFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if ((Integer)caretOffset.get() > 0 && YAMLEnterAtIndentHandler.shouldInsertAutomaticHyphen(file) && PsiUtilCore.getElementType((PsiElement)(element = file.findElementAt((Integer)caretOffset.get() - 1))) == TokenType.WHITE_SPACE && element.getTextLength() == 1 && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element)) == YAMLTokenTypes.SEQUENCE_MARKER) {
            int indentSize = Objects.requireNonNull(CodeStyle.getLanguageSettings((PsiFile)file, (Language)YAMLLanguage.INSTANCE).getIndentOptions()).INDENT_SIZE;
            editor.getDocument().replaceString((Integer)caretOffset.get() - 2, ((Integer)caretOffset.get()).intValue(), (CharSequence)StringUtil.repeat((String)" ", (int)indentSize));
            return EnterHandlerDelegate.Result.Stop;
        }
        if (BackspaceHandler.isWhitespaceBeforeCaret((Editor)editor)) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (!(file instanceof YAMLFile) || !file.isValid()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!YAMLEnterAtIndentHandler.shouldInsertAutomaticHyphen(file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = editor.getCaretModel().getOffset();
        if (caretOffset <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement element = file.findElementAt(caretOffset - 1);
        if (!YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)element))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiElement parent = element.getParent();
        IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
        if (parentType != YAMLElementTypes.SEQUENCE) {
            if (parentType != YAMLElementTypes.MAPPING) {
                return EnterHandlerDelegate.Result.Continue;
            }
            PsiElement prevElem = element.getPrevSibling();
            while (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)prevElem))) {
                prevElem = prevElem.getPrevSibling();
            }
            if (PsiUtilCore.getElementType((PsiElement)prevElem) != YAMLElementTypes.KEY_VALUE_PAIR) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (PsiUtilCore.getElementType((PsiElement)prevElem.getLastChild()) != YAMLElementTypes.SEQUENCE) {
                return EnterHandlerDelegate.Result.Continue;
            }
            if (YAMLUtil.getIndentToThisElement(prevElem.getLastChild()) != YAMLUtil.getIndentToThisElement(parent)) {
                return EnterHandlerDelegate.Result.Continue;
            }
        } else if (YAMLEnterAtIndentHandler.isEmptySequenceItem(element.getPrevSibling())) {
            return EnterHandlerDelegate.Result.Continue;
        }
        editor.getDocument().insertString(caretOffset, (CharSequence)"- ");
        editor.getCaretModel().moveToOffset(caretOffset + 2);
        return EnterHandlerDelegate.Result.Stop;
    }

    @Contract(value="null -> false")
    private static boolean isEmptySequenceItem(@Nullable PsiElement prevSibling) {
        return prevSibling instanceof YAMLSequenceItem && "-".equals(prevSibling.getText());
    }

    private static boolean shouldInsertAutomaticHyphen(@NotNull PsiFile file) {
        return ((YAMLCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, YAMLCodeStyleSettings.class)).AUTOINSERT_SEQUENCE_MARKER;
    }
}

