/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public final class YAMLLocalResolveUtil {
    private YAMLLocalResolveUtil() {
    }

    @NotNull
    public static Map<YAMLAlias, YAMLAnchor> getResolveAliasMap(@NotNull PsiFile file) {
        return YAMLLocalResolveUtil.getResolveData((PsiFile)file).myResolveMap;
    }

    @NotNull
    public static Collection<YAMLAnchor> getFirstAnchorDefs(@NotNull PsiFile file) {
        return YAMLLocalResolveUtil.getResolveData((PsiFile)file).myFirstDefs;
    }

    @NotNull
    private static YAMLAliasResolveResult getResolveData(@NotNull PsiFile file) {
        return (YAMLAliasResolveResult)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            final HashMap<YAMLAlias, YAMLAnchor> resolveMap = new HashMap<YAMLAlias, YAMLAnchor>();
            final HashMap defMap = new HashMap();
            final HashMap firstDefMap = new HashMap();
            file.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

                @Override
                public void visitAnchor(@NotNull YAMLAnchor anchor) {
                    defMap.put(anchor.getName(), anchor);
                    firstDefMap.putIfAbsent(anchor.getName(), anchor);
                }

                @Override
                public void visitAlias(@NotNull YAMLAlias alias) {
                    String name = alias.getAliasName();
                    YAMLAnchor anchor = (YAMLAnchor)defMap.get(name);
                    if (anchor != null) {
                        resolveMap.put(alias, anchor);
                    }
                }
            });
            HashSet<YAMLAnchor> firstDefs = new HashSet<YAMLAnchor>(firstDefMap.values());
            YAMLAliasResolveResult result = new YAMLAliasResolveResult(resolveMap, firstDefs);
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{file});
        });
    }

    private static class YAMLAliasResolveResult {
        @NotNull
        final Map<YAMLAlias, YAMLAnchor> myResolveMap;
        @NotNull
        final Set<YAMLAnchor> myFirstDefs;

        YAMLAliasResolveResult(@NotNull Map<YAMLAlias, YAMLAnchor> map, @NotNull Set<YAMLAnchor> firstDefs) {
            this.myResolveMap = Collections.unmodifiableMap(map);
            this.myFirstDefs = Collections.unmodifiableSet(firstDefs);
        }
    }
}

