/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;

public abstract class YAMLMappingImpl
extends YAMLCompoundValueImpl
implements YAMLMapping {
    public YAMLMappingImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Collection<YAMLKeyValue> getKeyValues() {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, YAMLKeyValue.class);
    }

    @Override
    @Nullable
    public YAMLKeyValue getKeyValueByKey(@NotNull String keyText) {
        for (YAMLKeyValue keyValue : this.getKeyValues()) {
            if (!keyText.equals(keyValue.getKeyText())) continue;
            return keyValue;
        }
        return null;
    }

    @Override
    public void putKeyValue(@NotNull YAMLKeyValue keyValueToAdd) {
        YAMLKeyValue existingKey = this.getKeyValueByKey(keyValueToAdd.getKeyText());
        if (existingKey == null) {
            this.addNewKey(keyValueToAdd);
        } else {
            existingKey.replace((PsiElement)keyValueToAdd);
        }
    }

    @Override
    public void deleteKeyValue(@NotNull YAMLKeyValue keyValueToDelete) {
        if (keyValueToDelete.getParent() != this) {
            throw new IllegalArgumentException("KeyValue should be the child of this");
        }
        YAMLUtil.deleteSurroundingWhitespace((PsiElement)keyValueToDelete);
        keyValueToDelete.delete();
    }

    protected abstract void addNewKey(@NotNull YAMLKeyValue var1);

    @Override
    public String toString() {
        return "YAML mapping";
    }

    @Override
    @NotNull
    public String getTextValue() {
        return "<mapping:" + Integer.toHexString(this.getText().hashCode()) + ">";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitMapping(this);
        } else {
            super.accept(visitor);
        }
    }
}

