/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlMetaType {
    @NotNull
    private final String myTypeName;
    @NotNull
    private String myDisplayName;

    protected YamlMetaType(@NonNls @NotNull String typeName) {
        this.myTypeName = typeName;
        this.myDisplayName = typeName;
    }

    @NotNull
    @Contract(pure=true)
    public final String getTypeName() {
        return this.myTypeName;
    }

    @NotNull
    @Contract(pure=true)
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @NotNull
    @Contract(pure=true)
    public Icon getIcon() {
        return AllIcons.Json.Object;
    }

    public void setDisplayName(@NonNls @NotNull String displayName) {
        this.myDisplayName = displayName;
    }

    @Nullable
    public abstract Field findFeatureByName(@NotNull String var1);

    @NotNull
    public abstract List<String> computeMissingFields(@NotNull Set<String> var1);

    @NotNull
    public abstract List<Field> computeKeyCompletions(@Nullable YAMLMapping var1);

    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
    }

    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
    }

    public void validateDeep(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        this.validateValue(value, problemsHolder);
        if (value instanceof YAMLMapping) {
            YAMLMapping mapping = (YAMLMapping)value;
            Collection<YAMLKeyValue> keyValues = mapping.getKeyValues();
            List<String> missingKeys = this.computeMissingFields(keyValues.stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet()));
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message("YamlMissingKeysInspectionBase.missing.keys", String.join((CharSequence)", ", missingKeys));
                problemsHolder.registerProblem((PsiElement)mapping, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            for (YAMLKeyValue keyValue : keyValues) {
                String featureName = keyValue.getKeyText().trim();
                if (featureName.isEmpty()) continue;
                Field feature = this.findFeatureByName(featureName);
                if (feature == null) {
                    String msg = YAMLBundle.message("YamlUnknownKeysInspectionBase.unknown.key", keyValue.getKeyText());
                    PsiElement key = keyValue.getKey();
                    assert (key != null);
                    problemsHolder.registerProblem(key, msg, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                    continue;
                }
                YAMLValue subValue = keyValue.getValue();
                if (subValue == null) {
                    if (feature.isEmptyValueAllowed()) continue;
                    continue;
                }
                Field.Relation relation = subValue instanceof YAMLScalar ? Field.Relation.SCALAR_VALUE : (subValue instanceof YAMLSequence ? Field.Relation.SEQUENCE_ITEM : Field.Relation.OBJECT_CONTENTS);
                YamlMetaType subType = feature.getType(relation);
                if (!(subValue instanceof YAMLSequence)) {
                    subType.validateDeep(subValue, problemsHolder);
                    continue;
                }
                List<YAMLSequenceItem> sequenceItems = ((YAMLSequence)subValue).getItems();
                for (YAMLSequenceItem item : sequenceItems) {
                    YAMLValue itemValue = item.getValue();
                    if (itemValue == null) {
                        if (feature.isEmptyValueAllowed()) continue;
                        continue;
                    }
                    subType.validateDeep(itemValue, problemsHolder);
                }
            }
        }
    }

    @NotNull
    public List<? extends LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        return Collections.emptyList();
    }

    public abstract void buildInsertionSuffixMarkup(@NotNull YamlInsertionMarkup var1, @NotNull Field.Relation var2, @NotNull ForcedCompletionPath.Iteration var3);

    protected static void buildCompleteKeyMarkup(@NotNull YamlInsertionMarkup markup, @NotNull Field feature, @NotNull ForcedCompletionPath.Iteration iteration) {
        markup.append(feature.getName());
        Field.Relation defaultRelation = feature.getDefaultRelation();
        YamlMetaType defaultType = feature.getType(defaultRelation);
        defaultType.buildInsertionSuffixMarkup(markup, defaultRelation, iteration);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.myTypeName + "@" + Integer.toHexString(this.hashCode());
    }

    @ApiStatus.Internal
    public static class ForcedCompletionPath {
        private static final Iteration OFF_PATH_ITERATION = new OffPathIteration();
        private static final Iteration NULL_ITERATION = new NullIteration();
        private static final ForcedCompletionPath NULL_PATH = new ForcedCompletionPath(null);
        @Nullable
        private final List<Field> myCompletionPath;

        @NotNull
        public static ForcedCompletionPath forDeepCompletion(@NotNull List<Field> completionPath) {
            return new ForcedCompletionPath(completionPath);
        }

        @NotNull
        public static ForcedCompletionPath nullPath() {
            return NULL_PATH;
        }

        private ForcedCompletionPath(@Nullable List<Field> completionPath) {
            this.myCompletionPath = completionPath;
        }

        @NotNull
        public String getName() {
            if (this.myCompletionPath == null) {
                return "<null>";
            }
            return this.myCompletionPath.stream().map(Field::getName).collect(Collectors.joining("."));
        }

        @Nullable
        public YamlMetaType getFinalizingType() {
            if (this.myCompletionPath == null || this.myCompletionPath.size() < 2) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 2).getDefaultType();
        }

        @Nullable
        public Field getFinalizingField() {
            if (this.myCompletionPath == null || this.myCompletionPath.isEmpty()) {
                return null;
            }
            return this.myCompletionPath.get(this.myCompletionPath.size() - 1);
        }

        public Iteration start() {
            return this.myCompletionPath != null ? new OnPathIteration(1) : NULL_ITERATION;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getName() + ")";
        }

        private class OnPathIteration
        implements Iteration {
            private final int myPosition;

            private OnPathIteration(int position) {
                this.myPosition = position;
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return !this.isEndOfPathReached() && field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition));
            }

            @Override
            public boolean isEndOfPathReached() {
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return this.myPosition >= ForcedCompletionPath.this.myCompletionPath.size();
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                assert (ForcedCompletionPath.this.myCompletionPath != null);
                return this.isEndOfPathReached() || field.equals(ForcedCompletionPath.this.myCompletionPath.get(this.myPosition)) ? new OnPathIteration(this.myPosition + 1) : OFF_PATH_ITERATION;
            }
        }

        private static class NullIteration
        implements Iteration {
            private NullIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return true;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                return this;
            }
        }

        private static class OffPathIteration
        implements Iteration {
            private OffPathIteration() {
            }

            @Override
            public boolean isNextOnPath(@NotNull Field field) {
                return false;
            }

            @Override
            public boolean isEndOfPathReached() {
                return false;
            }

            @Override
            @NotNull
            public Iteration nextIterationFor(@NotNull Field field) {
                return this;
            }
        }

        public static interface Iteration {
            public boolean isEndOfPathReached();

            public boolean isNextOnPath(@NotNull Field var1);

            @NotNull
            public Iteration nextIterationFor(@NotNull Field var1);
        }
    }

    @ApiStatus.Internal
    public static class YamlInsertionMarkup {
        public static final String CRLF_MARKUP = "<crlf>";
        public static final String CARET_MARKUP = "<caret>";
        public static final String SEQUENCE_ITEM_MARKUP = "- ";
        private final StringBuilder myOutput = new StringBuilder();
        private final String myTabSymbol;
        private int myLevel;
        private boolean myCaretAppended;

        public YamlInsertionMarkup(@NotNull InsertionContext context) {
            this(YamlInsertionMarkup.getTabSymbol(context));
        }

        public YamlInsertionMarkup(@NotNull String tabSymbol) {
            this.myTabSymbol = tabSymbol;
        }

        public void append(@NotNull String text) {
            this.myOutput.append(text);
        }

        public void newLineAndTabs() {
            this.newLineAndTabs(false);
        }

        public void newLineAndTabs(boolean withSequenceItemMark) {
            if (withSequenceItemMark) assert (this.myLevel > 0);
            this.append(CRLF_MARKUP);
            if (withSequenceItemMark) {
                this.append(this.tabs(this.myLevel - 1));
                this.append(this.sequenceItemPrefix());
            } else {
                this.append(this.tabs(this.myLevel));
            }
        }

        @NotNull
        private String sequenceItemPrefix() {
            String result = SEQUENCE_ITEM_MARKUP;
            if (this.myTabSymbol.length() > result.length()) {
                result = result + this.myTabSymbol.substring(result.length());
            }
            return result;
        }

        public void appendCaret() {
            if (!this.myCaretAppended) {
                this.append(CARET_MARKUP);
            }
            this.myCaretAppended = true;
        }

        public String getMarkup() {
            return this.myOutput.toString();
        }

        public void increaseTabs(int indent) {
            assert (indent > 0);
            this.myLevel += indent;
        }

        public void doTabbedBlock(int indent, @NotNull Runnable doWhenTabbed) {
            this.increaseTabs(indent);
            try {
                doWhenTabbed.run();
            }
            finally {
                this.decreaseTabs(indent);
            }
        }

        @NotNull
        public String getTabSymbol() {
            return this.myTabSymbol;
        }

        public void decreaseTabs(int indent) {
            assert (indent <= this.myLevel);
            this.myLevel -= indent;
        }

        private String tabs(int level) {
            return StringUtil.repeat((String)this.myTabSymbol, (int)level);
        }

        @NotNull
        private static String getTabSymbol(@NotNull InsertionContext context) {
            return StringUtil.repeatSymbol((char)' ', (int)CodeStyle.getIndentSize((PsiFile)context.getFile()));
        }

        public void insertStringAndCaret(Editor editor, String commonPadding) {
            String insertionMarkup = this.getMarkup();
            String suffixWithCaret = insertionMarkup.replace(CRLF_MARKUP, "\n" + commonPadding);
            int caretIndex = suffixWithCaret.indexOf(CARET_MARKUP);
            String suffix = suffixWithCaret.replace(CARET_MARKUP, "");
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)suffix, (boolean)false, (boolean)true, (int)caretIndex);
        }
    }
}

