/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Internal
public class YamlEnumType
extends YamlScalarType {
    private String[] myLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
    private String[] myHiddenLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;
    private String[] myDeprecatedLiterals = ArrayUtilRt.EMPTY_STRING_ARRAY;

    public YamlEnumType(@NotNull String typeName) {
        super(typeName);
    }

    @NotNull
    public YamlEnumType withLiterals(String ... literals) {
        this.myLiterals = YamlEnumType.cloneArray(literals);
        return this;
    }

    @NotNull
    public YamlEnumType withHiddenLiterals(String ... hiddenLiterals) {
        this.myHiddenLiterals = (String[])hiddenLiterals.clone();
        return this;
    }

    @NotNull
    public YamlEnumType withDeprecatedLiterals(String ... deprecatedLiterals) {
        this.myDeprecatedLiterals = (String[])deprecatedLiterals.clone();
        return this;
    }

    @NotNull
    protected final Stream<String> getLiteralsStream() {
        return Stream.concat(Arrays.stream(this.myLiterals), Arrays.stream(this.myDeprecatedLiterals));
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        super.validateScalarValue(scalarValue, holder);
        String text = scalarValue.getTextValue();
        if (text.isEmpty()) {
            return;
        }
        if (Arrays.asList(this.myDeprecatedLiterals).contains(text)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlEnumType.validation.warning.value.deprecated", text), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
        } else if (Stream.concat(Arrays.stream(this.myHiddenLiterals), this.getLiteralsStream()).noneMatch(text::equals)) {
            holder.registerProblem((PsiElement)scalarValue, YAMLBundle.message("YamlEnumType.validation.error.value.unknown", text), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        return Stream.concat(Arrays.stream(this.myLiterals).map(literal -> this.createValueLookup((String)literal, false)), Arrays.stream(this.myDeprecatedLiterals).map(literal -> this.createValueLookup((String)literal, true))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    protected LookupElement createValueLookup(@NotNull String literal, boolean deprecated) {
        return LookupElementBuilder.create((String)literal).withStrikeoutness(deprecated);
    }

    private static String @NotNull [] cloneArray(String @NotNull [] array) {
        return array.length == 0 ? ArrayUtilRt.EMPTY_STRING_ARRAY : (String[])array.clone();
    }
}

