/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLMapping;

@ApiStatus.Internal
public class YamlAnything
extends YamlMetaType {
    private static final YamlAnything ourInstance = new YamlAnything();
    private static final Field ourAnyField = new Field("<any-key>", ourInstance).withAnyName().withRelationSpecificType(Field.Relation.SEQUENCE_ITEM, ourInstance).withRelationSpecificType(Field.Relation.SCALAR_VALUE, ourInstance).withEmptyValueAllowed(true);

    public YamlAnything() {
        super("yaml:anything");
    }

    @Override
    @Nullable
    public Field findFeatureByName(@NotNull String name) {
        return ourAnyField;
    }

    @Override
    @NotNull
    public List<String> computeMissingFields(@NotNull Set<String> existingFields) {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public List<Field> computeKeyCompletions(@Nullable YAMLMapping existingMapping) {
        return Collections.emptyList();
    }

    @Override
    public void buildInsertionSuffixMarkup(@NotNull YamlMetaType.YamlInsertionMarkup markup, @NotNull Field.Relation relation, @NotNull YamlMetaType.ForcedCompletionPath.Iteration iteration) {
        markup.append(": ");
        if (iteration.isEndOfPathReached()) {
            markup.appendCaret();
        }
    }

    public static YamlMetaType getInstance() {
        return ourInstance;
    }
}

