/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.TypeFieldPair;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public abstract class YamlDocumentationProviderBase
implements DocumentationProvider {
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof DocumentationElement)) {
            return null;
        }
        return ((DocumentationElement)element).getDocumentation();
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (contextElement == null || !this.isRelevant(contextElement)) {
            return null;
        }
        return this.createFromPsiElement(contextElement);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement contextElement) {
        if (!this.isRelevant(contextElement)) {
            return null;
        }
        if (object instanceof YamlMetaType.ForcedCompletionPath) {
            return this.createFromCompletionPath((YamlMetaType.ForcedCompletionPath)object, contextElement);
        }
        if (object instanceof TypeFieldPair) {
            return this.createFromField((TypeFieldPair)object, contextElement);
        }
        if (object instanceof String) {
            return this.createFromString((String)object, contextElement);
        }
        return null;
    }

    protected abstract boolean isRelevant(@NotNull PsiElement var1);

    @Nullable
    protected abstract String getDocumentation(@NotNull Project var1, @NotNull YamlMetaType var2, @Nullable Field var3);

    @Nullable
    protected abstract YamlMetaTypeProvider getMetaTypeProvider(@NotNull PsiElement var1);

    @Nullable
    private static <T extends PsiElement> T getTypedAncestorOrSelf(@NotNull PsiElement psi, @NotNull Class<? extends T> clazz) {
        return (T)(clazz.isInstance(psi) ? (PsiElement)clazz.cast(psi) : PsiTreeUtil.getParentOfType((PsiElement)psi, clazz));
    }

    @Nullable
    private DocumentationElement createFromPsiElement(@Nullable PsiElement contextElement) {
        YamlMetaTypeProvider.MetaTypeProxy objectMetatype;
        YamlMetaTypeProvider.MetaTypeProxy fieldMetatype;
        if (contextElement == null) {
            return null;
        }
        YamlMetaTypeProvider modelProvider = this.getMetaTypeProvider(contextElement);
        if (modelProvider == null) {
            return null;
        }
        YAMLPsiElement yamlElement = YamlDocumentationProviderBase.getTypedAncestorOrSelf(contextElement, YAMLPsiElement.class);
        if (yamlElement == null) {
            return null;
        }
        if (yamlElement instanceof YAMLValue) {
            fieldMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            YAMLMapping mapping = YamlDocumentationProviderBase.getTypedAncestorOrSelf((PsiElement)yamlElement, YAMLMapping.class);
            YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = objectMetatype = mapping != null ? modelProvider.getMetaTypeProxy((PsiElement)mapping) : null;
            if (mapping != null && fieldMetatype != null && fieldMetatype.getField().getName().equals("kind") && mapping.getKeyValues().stream().anyMatch(kv -> "apiVersion".equals(kv.getKeyText().trim()))) {
                fieldMetatype = null;
            }
        } else if (yamlElement instanceof YAMLKeyValue) {
            objectMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            fieldMetatype = modelProvider.getKeyValueMetaType((YAMLKeyValue)yamlElement);
        } else {
            objectMetatype = modelProvider.getMetaTypeProxy((PsiElement)yamlElement);
            fieldMetatype = null;
        }
        if (objectMetatype == null) {
            return null;
        }
        return new DocumentationElement(contextElement.getManager(), objectMetatype.getMetaType(), fieldMetatype != null ? fieldMetatype.getField() : null);
    }

    @Nullable
    private DocumentationElement createFromCompletionPath(@NotNull YamlMetaType.ForcedCompletionPath path, @NotNull PsiElement contextElement) {
        YamlMetaTypeProvider typeProvider = this.getMetaTypeProvider(contextElement);
        if (typeProvider == null) {
            return null;
        }
        Field field = path.getFinalizingField();
        if (field == null) {
            return null;
        }
        YamlMetaType type = path.getFinalizingType();
        if (type == null) {
            YamlMetaTypeProvider.MetaTypeProxy proxy = typeProvider.getMetaTypeProxy(contextElement);
            if (proxy == null) {
                return null;
            }
            type = proxy.getMetaType();
        }
        return new DocumentationElement(contextElement.getManager(), type, field);
    }

    @Nullable
    private DocumentationElement createFromString(@NotNull String fieldName, @NotNull PsiElement contextElement) {
        YamlMetaTypeProvider typeProvider = this.getMetaTypeProvider(contextElement);
        if (typeProvider == null) {
            return null;
        }
        YamlMetaTypeProvider.MetaTypeProxy proxy = typeProvider.getMetaTypeProxy(contextElement);
        if (proxy == null) {
            return null;
        }
        Field field = proxy.getMetaType().findFeatureByName(fieldName);
        if (field == null) {
            return null;
        }
        return new DocumentationElement(contextElement.getManager(), proxy.getMetaType(), field);
    }

    @NotNull
    private DocumentationElement createFromField(@NotNull TypeFieldPair field, @NotNull PsiElement contextElement) {
        return new DocumentationElement(contextElement.getManager(), field.getMetaType(), field.getField());
    }

    private class DocumentationElement
    extends LightElement {
        @NotNull
        private final Project myProject;
        @NotNull
        private final YamlMetaType myType;
        @Nullable
        private final Field myField;

        DocumentationElement(@NotNull PsiManager manager, @Nullable YamlMetaType type, Field field) {
            super(manager, (Language)YAMLLanguage.INSTANCE);
            this.myProject = manager.getProject();
            this.myType = type;
            this.myField = field;
        }

        public String toString() {
            return "DocumentationElement: " + this.myType + "#" + this.myField;
        }

        public String getText() {
            return this.myField != null ? this.myField.getName() + " : " + this.myField.getDefaultType().getDisplayName() : this.myType.getDisplayName();
        }

        @Nullable
        public String getDocumentation() {
            return YamlDocumentationProviderBase.this.getDocumentation(this.myProject, this.myType, this.myField);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            DocumentationElement element = (DocumentationElement)((Object)o);
            return Objects.equals(this.myProject, element.myProject) && Objects.equals(this.myType, element.myType) && Objects.equals(this.myField, element.myField);
        }

        public int hashCode() {
            return Objects.hash(this.myProject, this.myType, this.myField);
        }
    }
}

