/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLFormattingContext;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

class YAMLBlockScalarItemBlock
implements Block {
    @NotNull
    final TextRange myRange;
    @Nullable
    final Indent myIndent;
    @Nullable
    final Alignment myAlignment;

    private YAMLBlockScalarItemBlock(@NotNull TextRange range, @Nullable Indent indent, @Nullable Alignment alignment) {
        this.myRange = range;
        this.myIndent = indent;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.myRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        return Collections.emptyList();
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    @NotNull
    static Block createBlockScalarItem(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        Indent indent;
        TextRange range;
        ASTNode blockScalarNode = node.getTreeParent();
        YAMLBlockScalarImpl blockScalarImpl = (YAMLBlockScalarImpl)blockScalarNode.getPsi();
        int parentFullIndent = YAMLBlockScalarItemBlock.getParentFullIndent(context, blockScalarNode.getTreeParent());
        Alignment alignment = null;
        int oldOffset = Math.max(YAMLBlockScalarItemBlock.getNodeFullIndent(node) - parentFullIndent, 0);
        if (blockScalarImpl.hasExplicitIndent()) {
            range = new TextRange(node.getStartOffset() - oldOffset, node.getTextRange().getEndOffset());
            indent = Indent.getSpaceIndent((int)0, (boolean)true);
        } else {
            int needOffset = Math.max(oldOffset - YAMLBlockScalarItemBlock.getFirstLineOffset(context, blockScalarImpl), 0);
            range = new TextRange(node.getStartOffset() - needOffset, node.getTextRange().getEndOffset());
            alignment = context.computeAlignment(node);
            indent = Indent.getNormalIndent((boolean)true);
        }
        return new YAMLBlockScalarItemBlock(range, indent, alignment);
    }

    private static int getFirstLineOffset(@NotNull YAMLFormattingContext context, @NotNull YAMLBlockScalarImpl blockScalarPsi) {
        int parentFullIndent = YAMLBlockScalarItemBlock.getParentFullIndent(context, blockScalarPsi.getNode().getTreeParent());
        ASTNode firstLine = blockScalarPsi.getNthContentTypeChild(1);
        if (firstLine == null) {
            return 0;
        }
        return Math.max(YAMLBlockScalarItemBlock.getNodeFullIndent(firstLine) - parentFullIndent, 0);
    }

    private static int getParentFullIndent(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        String fullText = context.getFullText();
        int start = node.getTextRange().getStartOffset();
        for (int cur = start - 1; cur >= 0; --cur) {
            if (fullText.charAt(cur) == '\n') {
                return start - cur - 1;
            }
            if (start - cur <= 1000) continue;
            return 0;
        }
        return start;
    }

    private static int getNodeFullIndent(@NotNull ASTNode node) {
        ASTNode indentNode = node.getTreePrev();
        if (indentNode == null || indentNode.getElementType() != YAMLTokenTypes.INDENT) {
            return 0;
        }
        return indentNode.getTextLength();
    }
}

