/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AccessibleContextUtil {
    static final String PUNCTUATION_CHARACTER = ".";
    static final String PUNCTUATION_SEPARATOR = "  ";

    public static void setName(@NotNull Component component, String name) {
        AccessibleContextUtil.setAccessibleName(component, name);
    }

    public static void setName(@NotNull Component component, @NotNull Component source) {
        AccessibleContextUtil.setName(component, AccessibleContextUtil.getAccessibleName(source));
    }

    public static void setCombinedName(@NotNull Component component, @NotNull Component j1, @NotNull String separator, @NotNull Component j2) {
        AccessibleContextUtil.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2)));
    }

    public static void setCombinedName(@NotNull Component component, @NotNull Component j1, @NotNull String separator1, @NotNull Component j2, @NotNull String separator2, @NotNull Component j3) {
        AccessibleContextUtil.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3)));
    }

    public static String getCombinedName(@NotNull Component j1, @NotNull String separator, @NotNull Component j2) {
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2));
    }

    public static String getCombinedName(@NotNull Component j1, @NotNull String separator1, @NotNull Component j2, @NotNull String separator2, @NotNull Component j3) {
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3));
    }

    public static String getCombinedName(@NotNull String separator, Component ... components) {
        String result = "";
        for (Component c : components) {
            result = AccessibleContextUtil.combineAccessibleStrings(result, separator, AccessibleContextUtil.getAccessibleName(c));
        }
        return result;
    }

    public static void setDescription(@NotNull Component component, @NotNull Component source) {
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.getAccessibleDescription(source));
    }

    public static void setDescription(@NotNull Component component, String description) {
        AccessibleContextUtil.setAccessibleDescription(component, description);
    }

    public static void setCombinedDescription(@NotNull Component component, @NotNull Component j1, @NotNull String separator, @NotNull Component j2) {
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2)));
    }

    public static void setCombinedDescription(@NotNull Component component, @NotNull Component j1, @NotNull String separator1, @NotNull Component j2, @NotNull String separator2, @NotNull Component j3) {
        AccessibleContextUtil.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3)));
    }

    public static String getCombinedDescription(@NotNull Component j1, @NotNull String separator, @NotNull Component j2) {
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2));
    }

    public static String getCombinedDescription(@NotNull Component j1, @NotNull String separator1, @NotNull Component j2, @NotNull String separator2, @NotNull Component j3) {
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3));
    }

    @Nullable
    public static String getUniqueDescription(@NotNull AccessibleContext context, @Nullable String description) {
        String name = context.getAccessibleName();
        if (StringUtil.equals((CharSequence)description, (CharSequence)name)) {
            return null;
        }
        return description;
    }

    public static void setParent(@NotNull Component component, @Nullable Component newParent) {
        if (newParent instanceof Accessible) {
            component.getAccessibleContext().setAccessibleParent((Accessible)((Object)newParent));
            return;
        }
        component.getAccessibleContext().setAccessibleParent(null);
    }

    @Deprecated
    public static void setParent(@NotNull JComponent component, @Nullable Component newParent) {
        AccessibleContextUtil.setParent((Component)component, newParent);
    }

    @Nullable
    public static String combineAccessibleStrings(@Nullable String s1, @Nullable String s2) {
        return AccessibleContextUtil.combineAccessibleStrings(s1, " ", s2);
    }

    @Nullable
    public static String combineAccessibleStrings(@Nullable String s1, @NotNull String separator, @Nullable String s2) {
        if (StringUtil.isEmpty((String)s1)) {
            return s2;
        }
        if (StringUtil.isEmpty((String)s2)) {
            return s1;
        }
        return String.format("%s%s%s", s1, separator, s2);
    }

    @Nullable
    public static String combineAccessibleStrings(@Nullable String s1, @NotNull String separator1, @Nullable String s2, @NotNull String separator2, @Nullable String s3) {
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.combineAccessibleStrings(s1, separator1, s2), separator2, s3);
    }

    @NotNull
    public static String replaceLineSeparatorsWithPunctuation(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        String[] lines = StringUtil.splitByLines((String)text);
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            if (StringUtil.isEmpty((String)(line = line.trim()))) continue;
            if (first) {
                first = false;
            } else {
                result.append(PUNCTUATION_SEPARATOR);
            }
            result.append(line);
            if (line.endsWith(PUNCTUATION_CHARACTER)) continue;
            result.append(PUNCTUATION_CHARACTER);
        }
        return result.toString();
    }

    private static String getAccessibleName(@NotNull Component component) {
        if (component instanceof Accessible) {
            return component.getAccessibleContext().getAccessibleName();
        }
        return null;
    }

    private static void setAccessibleName(@NotNull Component component, String name) {
        if (component instanceof Accessible) {
            component.getAccessibleContext().setAccessibleName(name);
        }
    }

    private static String getAccessibleDescription(@NotNull Component component) {
        if (component instanceof Accessible) {
            return component.getAccessibleContext().getAccessibleDescription();
        }
        return null;
    }

    private static void setAccessibleDescription(@NotNull Component component, String description) {
        if (component instanceof Accessible) {
            component.getAccessibleContext().setAccessibleDescription(description);
        }
    }
}

