/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.scale.JBUIScale;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class LocationOnDragTracker {
    private Point myOffsetXY;
    private Rectangle myMonitorBounds;
    private double myScale;

    private LocationOnDragTracker(MouseEvent e) {
        this.myOffsetXY = e.getPoint();
        this.myMonitorBounds = e.getComponent().getGraphicsConfiguration().getBounds();
        this.myScale = JBUIScale.sysScale(e.getComponent());
    }

    public static LocationOnDragTracker startDrag(@NotNull MouseEvent pressEvent) {
        assert (pressEvent.getID() == 501);
        return new LocationOnDragTracker(pressEvent);
    }

    public void updateLocationOnDrag(@NotNull Component draggedComp) {
        PointerInfo mouseInfo = MouseInfo.getPointerInfo();
        if (mouseInfo == null) {
            return;
        }
        Point mouseLocation = mouseInfo.getLocation();
        Point offsetXY = this.myOffsetXY.getLocation();
        if (!this.myMonitorBounds.contains(mouseLocation)) {
            for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!gd.getDefaultConfiguration().getBounds().contains(mouseLocation)) continue;
                double scale = JBUIScale.sysScale(gd.getDefaultConfiguration());
                int offX = (int)((double)this.myOffsetXY.x * this.myScale / scale);
                int offY = (int)((double)this.myOffsetXY.y * this.myScale / scale);
                this.myOffsetXY = new Point(offX, offY);
                this.myMonitorBounds = gd.getDefaultConfiguration().getBounds();
                this.myScale = scale;
                offsetXY.setLocation(this.myOffsetXY);
            }
        }
        Point newLocation = mouseLocation.getLocation();
        newLocation.translate(-offsetXY.x, -offsetXY.y);
        draggedComp.setLocation(newLocation);
    }
}

