/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JBValue {
    protected JBValue() {
    }

    public int get() {
        return PaintUtil.RoundingMode.ROUND.round(JBUIScale.scale(this.getUnscaled()));
    }

    public float getFloat() {
        return JBUIScale.scale(this.getUnscaled());
    }

    public int get(@NotNull PaintUtil.RoundingMode rm) {
        return rm.round(JBUIScale.scale(this.getUnscaled()));
    }

    protected abstract float getUnscaled();

    public static class JBValueGroup {
        private final List<CachedFloat> group = new LinkedList<CachedFloat>();
        private final PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                for (CachedFloat value : group) {
                    value.scaleAndCache();
                }
            }
        };

        public JBValueGroup() {
            JBUIScale.addUserScaleChangeListener(this.listener);
        }

        public JBValue value(float value) {
            CachedFloat v = new CachedFloat(value);
            this.group.add(v);
            return v;
        }

        public void dispose() {
            JBUIScale.removeUserScaleChangeListener(this.listener);
            this.group.clear();
        }
    }

    private static class CachedFloat
    extends Float {
        private float cachedScaledValue;

        protected CachedFloat(float value) {
            super(value);
            this.scaleAndCache();
        }

        @Override
        public int get() {
            return PaintUtil.RoundingMode.ROUND.round(this.cachedScaledValue);
        }

        @Override
        public float getFloat() {
            return this.cachedScaledValue;
        }

        @Override
        public int get(@NotNull PaintUtil.RoundingMode rm) {
            return rm.round(this.cachedScaledValue);
        }

        public void scaleAndCache() {
            this.cachedScaledValue = JBUIScale.scale(this.getUnscaled());
        }
    }

    public static class Float
    extends JBValue {
        private final float value;

        public Float(float value) {
            this.value = value;
        }

        @Override
        protected float getUnscaled() {
            return this.value;
        }
    }

    public static class UIInteger
    extends JBValue {
        @NotNull
        private final String key;
        private final int defValue;

        public UIInteger(@NotNull String key, int defValue) {
            this.key = key;
            this.defValue = defValue;
        }

        @Override
        protected float getUnscaled() {
            return JBUI.getInt(this.key, this.defValue);
        }
    }
}

