/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.Scaler;
import com.intellij.ui.scale.UserScaleContextSupport;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class JBScalableIcon
extends UserScaleContextSupport
implements ScalableIcon {
    private final Scaler myScaler = new Scaler(){

        @Override
        protected double currentScale() {
            if (JBScalableIcon.this.autoUpdateScaleContext) {
                JBScalableIcon.this.getScaleContext().update();
            }
            return JBScalableIcon.this.getScale(ScaleType.USR_SCALE);
        }
    };
    private boolean autoUpdateScaleContext = true;

    public JBScalableIcon() {
    }

    protected JBScalableIcon(@NotNull JBScalableIcon icon) {
        this();
        this.updateScaleContext(icon.getScaleContext());
        this.myScaler.update(icon.myScaler);
        this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
    }

    protected boolean isIconPreScaled() {
        return this.myScaler.isPreScaled();
    }

    protected void setIconPreScaled(boolean preScaled) {
        this.myScaler.setPreScaled(preScaled);
    }

    @NotNull
    public JBScalableIcon withIconPreScaled(boolean preScaled) {
        this.setIconPreScaled(preScaled);
        return this;
    }

    protected void setAutoUpdateScaleContext(boolean autoUpdate) {
        this.autoUpdateScaleContext = autoUpdate;
    }

    public float getScale() {
        return (float)this.getScale(ScaleType.OBJ_SCALE);
    }

    @NotNull
    public Icon scale(float scale) {
        this.setScale(ScaleType.OBJ_SCALE.of(scale));
        return this;
    }

    protected double scaleVal(double value) {
        return this.scaleVal(value, DerivedScaleType.PIX_SCALE);
    }

    protected double scaleVal(double value, @NotNull ScaleType type) {
        switch (type) {
            case USR_SCALE: {
                return this.myScaler.scaleVal(value);
            }
            case SYS_SCALE: {
                return value * this.getScale(ScaleType.SYS_SCALE);
            }
            case OBJ_SCALE: {
                return value * this.getScale(ScaleType.OBJ_SCALE);
            }
        }
        return value;
    }

    protected double scaleVal(double value, @NotNull DerivedScaleType type) {
        switch (type) {
            case DEV_SCALE: {
                return value * this.getScale(DerivedScaleType.DEV_SCALE);
            }
            case EFF_USR_SCALE: 
            case PIX_SCALE: {
                return this.myScaler.scaleVal(value) * this.getScale(ScaleType.OBJ_SCALE);
            }
        }
        return value;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
    }
}

