/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.SmartList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserScaleContext {
    protected Scale usrScale = ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f));
    protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
    protected double pixScale;
    private List<UpdateListener> listeners;
    private EnumSet<ScaleType> overriddenScales;

    protected UserScaleContext() {
        this.pixScale = this.usrScale.value;
    }

    @NotNull
    public static UserScaleContext createIdentity() {
        return UserScaleContext.create(ScaleType.USR_SCALE.of(1.0));
    }

    @NotNull
    public static UserScaleContext create(Scale ... scales) {
        UserScaleContext ctx = UserScaleContext.create();
        for (Scale s : scales) {
            ctx.setScale(s);
        }
        return ctx;
    }

    @NotNull
    public static UserScaleContext create() {
        return new UserScaleContext();
    }

    @NotNull
    public static UserScaleContext create(@Nullable UserScaleContext ctx) {
        UserScaleContext c = UserScaleContext.createIdentity();
        c.update(ctx);
        return c;
    }

    protected double derivePixScale() {
        return this.usrScale.value * this.objScale.value;
    }

    public boolean overrideScale(@NotNull Scale scale) {
        if (this.overriddenScales != null) {
            this.overriddenScales.remove((Object)scale.type);
        }
        boolean updated = this.setScale(scale);
        if (this.overriddenScales == null) {
            this.overriddenScales = EnumSet.of(scale.type);
        } else {
            this.overriddenScales.add(scale.type);
        }
        return updated;
    }

    protected boolean isScaleOverridden(@NotNull Scale scale) {
        return this.overriddenScales != null && this.overriddenScales.contains((Object)scale.type);
    }

    public boolean setScale(@NotNull Scale scale) {
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        boolean updated = false;
        switch (scale.type) {
            case USR_SCALE: {
                updated = !this.usrScale.equals(scale);
                this.usrScale = scale;
                break;
            }
            case OBJ_SCALE: {
                updated = !this.objScale.equals(scale);
                this.objScale = scale;
                break;
            }
            case SYS_SCALE: {
                return false;
            }
        }
        return this.onUpdated(updated);
    }

    public double getScale(@NotNull ScaleType type) {
        switch (type) {
            case USR_SCALE: {
                return this.usrScale.value;
            }
            case SYS_SCALE: {
                return 1.0;
            }
            case OBJ_SCALE: {
                return this.objScale.value;
            }
        }
        return 1.0;
    }

    public double getScale(@NotNull DerivedScaleType type) {
        switch (type) {
            case DEV_SCALE: {
                return 1.0;
            }
            case PIX_SCALE: 
            case EFF_USR_SCALE: {
                return this.pixScale;
            }
        }
        return 1.0;
    }

    public double apply(double value, DerivedScaleType type) {
        return value * this.getScale(type);
    }

    public double apply(double value, ScaleType type) {
        return value * this.getScale(type);
    }

    protected boolean onUpdated(boolean updated) {
        if (updated) {
            this.pixScale = this.derivePixScale();
            this.notifyUpdateListeners();
        }
        return updated;
    }

    public boolean update() {
        return this.onUpdated(this.setScale(ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f))));
    }

    public boolean update(@Nullable UserScaleContext ctx) {
        if (ctx == null) {
            return this.update();
        }
        return this.onUpdated(this.updateAll(ctx));
    }

    protected <T extends UserScaleContext> boolean updateAll(@NotNull T ctx) {
        boolean updated = this.setScale(ctx.usrScale);
        return this.setScale(ctx.objScale) || updated;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UserScaleContext)) {
            return false;
        }
        UserScaleContext that = (UserScaleContext)obj;
        return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
    }

    public int hashCode() {
        return Double.hashCode(this.usrScale.value) * 31 + Double.hashCode(this.objScale.value);
    }

    public void dispose() {
        this.listeners = null;
    }

    public void addUpdateListener(@NotNull UpdateListener l) {
        if (this.listeners == null) {
            this.listeners = new SmartList((Object)l);
        } else {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(@NotNull UpdateListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    protected void notifyUpdateListeners() {
        if (this.listeners != null) {
            this.listeners.forEach(UpdateListener::contextUpdated);
        }
    }

    @NotNull
    public <T extends UserScaleContext> T copy() {
        UserScaleContext ctx = UserScaleContext.createIdentity();
        ctx.updateAll(this);
        return (T)ctx;
    }

    public String toString() {
        return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
    }

    public static class Cache<D, S extends UserScaleContext> {
        private final Function<? super S, ? extends D> myDataProvider;
        private final AtomicReference<Pair<Double, D>> myData = new AtomicReference<Object>(null);

        public Cache(@NotNull Function<? super S, ? extends D> dataProvider) {
            this.myDataProvider = dataProvider;
        }

        @Nullable
        public D getOrProvide(@NotNull S ctx) {
            Pair data = this.myData.get();
            double scale = ((UserScaleContext)ctx).getScale(DerivedScaleType.PIX_SCALE);
            if (data == null || Double.compare(scale, (Double)data.first) != 0) {
                data = Pair.create((Object)scale, this.myDataProvider.apply(ctx));
                this.myData.set(data);
            }
            return (D)data.second;
        }

        public void clear() {
            this.myData.set(null);
        }
    }

    public static interface UpdateListener {
        public void contextUpdated();
    }
}

