/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScaleContext
extends JBUI.BaseScaleContext {
    protected Scale sysScale = ScaleType.SYS_SCALE.of(JBUIScale.sysScale());
    @Nullable
    protected WeakReference<Component> compRef;

    protected ScaleContext() {
        this.pixScale = this.derivePixScale();
    }

    protected ScaleContext(@NotNull Scale scale) {
        this();
        this.setScale(scale);
    }

    @NotNull
    public static ScaleContext createIdentity() {
        return ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
    }

    @NotNull
    public static ScaleContext create(@Nullable UserScaleContext ctx) {
        ScaleContext c = ScaleContext.create();
        c.update(ctx);
        return c;
    }

    @NotNull
    public static ScaleContext create(@Nullable Component comp) {
        ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(comp)));
        if (comp != null) {
            ctx.compRef = new WeakReference<Component>(comp);
        }
        return ctx;
    }

    @NotNull
    public static ScaleContext create(@Nullable GraphicsConfiguration gc) {
        return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(gc)));
    }

    @NotNull
    public static ScaleContext create(Graphics2D g) {
        return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(g)));
    }

    @NotNull
    public static ScaleContext create(@NotNull Scale scale) {
        return new ScaleContext(scale);
    }

    @NotNull
    public static ScaleContext create(Scale ... scales) {
        ScaleContext ctx = ScaleContext.create();
        for (Scale s : scales) {
            ctx.setScale(s);
        }
        return ctx;
    }

    @NotNull
    public static ScaleContext create() {
        return new ScaleContext();
    }

    @Override
    protected double derivePixScale() {
        return this.getScale(DerivedScaleType.DEV_SCALE) * super.derivePixScale();
    }

    @Override
    public double getScale(@NotNull ScaleType type) {
        if (type == ScaleType.SYS_SCALE) {
            return this.sysScale.value;
        }
        return super.getScale(type);
    }

    @Override
    public double getScale(@NotNull DerivedScaleType type) {
        switch (type) {
            case DEV_SCALE: {
                return JreHiDpiUtil.isJreHiDPIEnabled() ? this.sysScale.value : 1.0;
            }
            case EFF_USR_SCALE: {
                return this.usrScale.value * this.objScale.value;
            }
            case PIX_SCALE: {
                return this.pixScale;
            }
        }
        return 1.0;
    }

    @Override
    public boolean update() {
        Component comp;
        boolean updated = this.setScale(ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f)));
        if (this.compRef != null && (comp = (Component)this.compRef.get()) != null) {
            updated = this.setScale(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(comp))) || updated;
        }
        return this.onUpdated(updated);
    }

    @Override
    public boolean setScale(@NotNull Scale scale) {
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        if (scale.type == ScaleType.SYS_SCALE) {
            boolean updated = !this.sysScale.equals(scale);
            this.sysScale = scale;
            return this.onUpdated(updated);
        }
        return super.setScale(scale);
    }

    @Override
    protected <T extends UserScaleContext> boolean updateAll(@NotNull T ctx) {
        boolean updated = super.updateAll(ctx);
        if (!(ctx instanceof ScaleContext)) {
            return updated;
        }
        ScaleContext context = (ScaleContext)ctx;
        if (this.compRef != null) {
            this.compRef.clear();
        }
        this.compRef = context.compRef;
        return this.setScale(context.sysScale) || updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof ScaleContext) {
            ScaleContext that = (ScaleContext)obj;
            return that.sysScale.value == this.sysScale.value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.sysScale.value) * 31 + super.hashCode();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.compRef != null) {
            this.compRef.clear();
        }
    }

    @Override
    @NotNull
    public <T extends UserScaleContext> T copy() {
        ScaleContext ctx = ScaleContext.createIdentity();
        ctx.updateAll(this);
        return (T)ctx;
    }

    @Override
    public String toString() {
        return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
    }

    public static class Cache<D>
    extends UserScaleContext.Cache<D, ScaleContext> {
        public Cache(@NotNull Function<? super ScaleContext, ? extends D> dataProvider) {
            super(dataProvider);
        }
    }
}

