/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SizedIcon
extends JBCachingScalableIcon
implements MenuBarIconProvider,
DarkIconProvider,
RetrievableIcon {
    private final int myWidth;
    private final int myHeight;
    @NotNull
    private final Icon myDelegate;
    private Icon myScaledDelegate;

    public SizedIcon(@NotNull Icon delegate, int width, int height) {
        this.myScaledDelegate = this.myDelegate = delegate;
        this.myWidth = width;
        this.myHeight = height;
    }

    private SizedIcon(@NotNull SizedIcon icon) {
        super(icon);
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myDelegate = icon.myDelegate;
        this.myScaledDelegate = null;
    }

    @Override
    @NotNull
    public SizedIcon copy() {
        return new SizedIcon(this);
    }

    @NotNull
    private Icon myScaledIcon() {
        Icon scaledDelegate = this.myScaledDelegate;
        if (scaledDelegate == null) {
            scaledDelegate = this.getScale() == 1.0f || !(this.myDelegate instanceof ScalableIcon) ? this.myDelegate : ((ScalableIcon)this.myDelegate).scale(this.getScale());
            this.myScaledDelegate = scaledDelegate;
        }
        return scaledDelegate;
    }

    @Override
    @NotNull
    public Icon getMenuBarIcon(boolean isDark) {
        return new SizedIcon(IconLoader.getMenuBarIcon(this.myDelegate, isDark), this.myWidth, this.myHeight);
    }

    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        return new SizedIcon(IconLoader.getDarkIcon(this.myDelegate, isDark), this.myWidth, this.myHeight);
    }

    @Override
    @NotNull
    public Icon retrieveIcon() {
        return this.myDelegate;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.myScaledIcon();
        double dx = this.scaleVal(this.myWidth) - (double)icon.getIconWidth();
        double dy = this.scaleVal(this.myHeight) - (double)icon.getIconHeight();
        if (dx > 0.0 || dy > 0.0) {
            icon.paintIcon(c, g, x + (int)Math.floor(dx / 2.0), y + (int)Math.floor(dy / 2.0));
        } else {
            icon.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        return (int)Math.ceil(this.scaleVal(this.myWidth));
    }

    @Override
    public int getIconHeight() {
        return (int)Math.ceil(this.scaleVal(this.myHeight));
    }
}

