/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.ThisExpression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ElementRenamedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;
import org.jetbrains.kotlin.j2k.usageProcessing.UseAccessorsJavaCodeProcessor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001dB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "field", "Lcom/intellij/psi/PsiField;", "propertyName", "", "isNullable", "", "replaceReadWithFieldReference", "replaceWriteWithFieldReference", "(Lcom/intellij/psi/PsiField;Ljava/lang/String;ZZZ)V", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "setJavaCodeProcessors", "(Ljava/util/List;)V", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ElementRenamedCodeProcessor;", "getKotlinCodeProcessors", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "MyConvertedCodeProcessor", "kotlin.j2k.old"})
public final class FieldToPropertyProcessing
implements UsageProcessing {
    @Nullable
    private final ConvertedCodeProcessor convertedCodeProcessor;
    @NotNull
    private List<? extends ExternalCodeProcessor> javaCodeProcessors;
    @NotNull
    private final List<ElementRenamedCodeProcessor> kotlinCodeProcessors;
    private final PsiField field;
    private final String propertyName;
    private final boolean isNullable;
    private final boolean replaceReadWithFieldReference;
    private final boolean replaceWriteWithFieldReference;

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.field;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return this.convertedCodeProcessor;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    public void setJavaCodeProcessors(@NotNull List<? extends ExternalCodeProcessor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.javaCodeProcessors = list;
    }

    @NotNull
    public List<ElementRenamedCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    public FieldToPropertyProcessing(@NotNull PsiField field, @NotNull String propertyName, boolean isNullable, boolean replaceReadWithFieldReference, boolean replaceWriteWithFieldReference) {
        List list;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        this.field = field;
        this.propertyName = propertyName;
        this.isNullable = isNullable;
        this.replaceReadWithFieldReference = replaceReadWithFieldReference;
        this.replaceWriteWithFieldReference = replaceWriteWithFieldReference;
        ConvertedCodeProcessor convertedCodeProcessor2 = this.convertedCodeProcessor = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true || this.replaceReadWithFieldReference || this.replaceWriteWithFieldReference ? (ConvertedCodeProcessor)new MyConvertedCodeProcessor() : null;
        if (this.field.hasModifierProperty("private")) {
            list = CollectionsKt.emptyList();
        } else if (Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true) {
            Object[] objectArray = new ExternalCodeProcessor[2];
            objectArray[0] = new ElementRenamedCodeProcessor(this.propertyName);
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.field.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"PsiElementFactory.getInstance(field.project)");
            objectArray[1] = new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName);
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.field.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"PsiElementFactory.getInstance(field.project)");
            list = CollectionsKt.listOf((Object)new UseAccessorsJavaCodeProcessor(psiElementFactory, this.propertyName));
        }
        this.javaCodeProcessors = list;
        this.kotlinCodeProcessors = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true ? CollectionsKt.listOf((Object)new ElementRenamedCodeProcessor(this.propertyName)) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing$MyConvertedCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;)V", "convertVariableUsage", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "kotlin.j2k.old"})
    private final class MyConvertedCodeProcessor
    implements ConvertedCodeProcessor {
        @Override
        @Nullable
        public Expression convertVariableUsage(@NotNull PsiReferenceExpression expression, @NotNull CodeConverter codeConverter) {
            PsiReferenceExpression psiReferenceExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
            boolean useFieldReference = FieldToPropertyProcessing.this.replaceReadWithFieldReference && PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)expression)) || FieldToPropertyProcessing.this.replaceWriteWithFieldReference && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression));
            Identifier identifier = Identifier.Companion.withNoPrototype$default(Identifier.Companion, useFieldReference ? "field" : FieldToPropertyProcessing.this.propertyName, FieldToPropertyProcessing.this.isNullable, false, null, 12, null);
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier != null && !useFieldReference) {
                return new QualifiedExpression(CodeConverter.convertExpression$default(codeConverter, qualifier, false, 2, null), identifier, UtilsKt.dot(expression));
            }
            PsiElementFactory elementFactory = PsiElementFactory.getInstance((Project)expression.getProject());
            try {
                PsiExpression psiExpression = elementFactory.createExpressionFromText(identifier.getName(), (PsiElement)expression);
                if (!(psiExpression instanceof PsiReferenceExpression)) {
                    psiExpression = null;
                }
                PsiReferenceExpression psiReferenceExpression2 = (PsiReferenceExpression)psiExpression;
                if (psiReferenceExpression2 == null) {
                    return identifier;
                }
                psiReferenceExpression = psiReferenceExpression2;
            }
            catch (IncorrectOperationException e) {
                return identifier;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            return refExpr.resolve() == null ? (Expression)identifier : (Expression)new QualifiedExpression((Expression)ElementKt.assignNoPrototype((Element)new ThisExpression(Identifier.Companion.getEmpty())), identifier, null);
        }

        @Override
        @Nullable
        public Expression convertMethodUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull CodeConverter codeConverter) {
            Intrinsics.checkNotNullParameter((Object)methodCall, (String)"methodCall");
            Intrinsics.checkNotNullParameter((Object)codeConverter, (String)"codeConverter");
            return ConvertedCodeProcessor.DefaultImpls.convertMethodUsage(this, methodCall, codeConverter);
        }
    }
}

