from __future__ import annotations

from ..providers.types          import BaseProvider, ProviderType
from ..providers.retry_provider import RetryProvider, IterListProvider
from ..providers.base_provider  import AsyncProvider, AsyncGeneratorProvider
from ..providers.create_images  import CreateImagesProvider

from .deprecated       import *
from .selenium         import *
from .needs_auth       import *
from .not_working      import *
from .local            import *

from .Airforce         import Airforce
from .AmigoChat        import AmigoChat
from .Blackbox         import Blackbox
from .Blackbox2        import Blackbox2
from .ChatGpt          import ChatGpt
from .ChatGptEs        import ChatGptEs
from .Cloudflare       import Cloudflare
from .Copilot          import Copilot
from .DarkAI           import DarkAI
from .DDG              import DDG
from .DeepInfraChat    import DeepInfraChat
from .Flux             import Flux
from .Free2GPT         import Free2GPT
from .FreeGpt          import FreeGpt
from .GizAI            import GizAI
from .Liaobots         import Liaobots
from .Mhystical        import Mhystical
from .PerplexityLabs   import PerplexityLabs
from .Pi               import Pi
from .Pizzagpt         import Pizzagpt
from .PollinationsAI   import PollinationsAI
from .Prodia           import Prodia
from .ReplicateHome    import ReplicateHome
from .RubiksAI         import RubiksAI
from .TeachAnything    import TeachAnything
from .You              import You

import sys

__modules__: list = [
    getattr(sys.modules[__name__], provider) for provider in dir()
    if not provider.startswith("__")
]
__providers__: list[ProviderType] = [
    provider for provider in __modules__
    if isinstance(provider, type)
    and issubclass(provider, BaseProvider)
]
__all__: list[str] = [
    provider.__name__ for provider in __providers__
]
__map__: dict[str, ProviderType] = dict([
    (provider.__name__, provider) for provider in __providers__
])

class ProviderUtils:
    convert: dict[str, ProviderType] = __map__
