# My first generation
Here are some example methods and tips on how to receive some initial good results.

Maybe it can give you some ideas and inspiration on how to use this tool. You can just leave everything on "all", which is the most fun!

It works best with models that are more general and multi purpose. Such as [deliberate](https://civitai.com/models/4823/deliberate) and [dreamlike diffusion](https://civitai.com/models/1274/dreamlike-diffusion-10). However, feel free to use it on your personal favorite models. If you want to generate images in a certain set style, of in the style of a certain model? That is possible as well, and explained in this page.

For models which are more trained on specific subjects, match the subject to the model to get the best results.

## Portraits

In this example, I am using the [deliberate](https://civitai.com/models/4823/deliberate) model. It is a very flexible model, and art styles have a good impact on the end results.

I've set the Sampling method to "DPM++ SDE Karras", Sampling steps to "25" and lowered the CFG Scale to "6"
You can increase the batch count, to keep creating new images.

![image](https://github.com/AIrjen/OneButtonPrompt/assets/130234949/07d2a841-bbf0-499b-baf3-d9c037c8e98d)


Then I scroll down and activate the One Button prompt script.

I set the complexity of the prompt to 5, which is a nice middle ground for prompts.

As a __"Subject Type"__ I select __"humanoid"__, this will ensure I will get a human, or human-like result from the prompt.

For __"Artists"__ I select __"popular"__. This is a list of popular artists from images from CivitAI. Such as LOIS, Artgerm, alphonse mucha and many others. You can also try and switch "artists" to __"Portrait"__ or __"Character"__

As __"Type of image"__ I select __"portrait"__, so that it will always default to a portrait image. You can also try to switch "Type of image" to __"digital art"__ to get more full body shots.

![image](https://github.com/AIrjen/OneButtonPrompt/assets/130234949/28e79a02-aba5-4a71-983b-d5edc9744cdc)

At that point, you can just press generate.

Examples:

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/21151b88-e5bb-471e-a66f-c95c05168c18.png" alt="click!" width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/da4ffb1f-1d38-4712-8141-4d4443c0b75a.png" alt="click!" width="30%" height="30%">

> portrait, ,close up of a Hopeless Slovak Mind Flayer, cosplaying as John Wick, Dark hair styled as Ballerina bun, Day of the Dead face paint, Desaturated, (art by Jeremy Mann:1.2)

> art by Greg Rutkowski, portrait, ,close up of a Brutal Micronesian [Sphinx|James from pokemon], wearing Russian Violet 1980s neon clothing, fashion modeling pose, at Nighttime, Visual novel, Grim, soft light, Infrared

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/5a835260-53e0-426b-aeef-bb048ea63905.png" alt="click!" width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/66609fa3-b657-4e4d-8db1-9cd8b3b635f4.png" alt="click!" width="30%" height="30%">

> portrait, ,close up of a Alluring Compelling Macedonian Tom Hardy, Skydiving, Bending backwards, Gray hair styled as Ponytail, from inside of a Cambridge, Simple illustration, Surprising, Heidelberg School, soft light, Magic the gathering, artstation

> portrait, ,close up of a plump Female Paladin, with Lycra skin, background is The Chaco Culture, art by Loish

## Photos
In this example, I am using the [Realistic Vision](https://civitai.com/models/4201/realistic-vision-v20) model.

I've set the Sampling method to "DPM++ SDE Karras", Sampling steps to "25" and kept the CFG Scale to "7"
You can increase the batch count, to keep creating new images.

I set the complexity of the prompt to 5, which is a nice middle ground for prompts. For photo's you might want to go a bit lower.

As a __"Subject Type"__ I select __"humanoid"__, as the Realistic Vision model likes to generate humans.

For __"Artists"__ I select __"photograph"__. This is a list of photography artists. However __"fashion"__ is also a good option here. I can also recommend __"none"__, so no artist is generated at all
When using Photograph artists, there is a very high chance of getting a portrait image.

As __"Type of image"__ I select __"portrait"__, so that it will always default to a portrait image.

![image](https://github.com/AIrjen/OneButtonPrompt/assets/130234949/928ba5ee-800c-4937-a641-595d6357af1c)

Examples:

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/6fed6b83-5ebe-44b1-bd30-3dad00ee6e4e.png" alt="click!" width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/a5fcd78a-ca82-4b33-ac7f-5f2c02720d81.png" alt="click!" width="30%" height="30%">

> [art by Tony Conrad|art by Ed Freeman], photograph, two shot angle of a Chanel Iman, wearing Ultrarealistic Preppy clothing, Honey hair styled as Short and messy, film grain, Canon 5d mark 4, macro lens

> photograph, High exposure of a Dynamic Ancient Male Writer, Dark hair styled as Tousled, Hazy conditions, Bloom light, film grain, Sony A9 II, Depth of field 100mm, Spirals, dslr, art by Larry Sultan, (art by Ray Collins:1.1)

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/18c3a1ab-cfa3-4975-8a8b-c4872daf86c4.png" alt="click!" width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/a67cf67b-6365-41a8-a791-b6a2b643b2ed.png" alt="click!" width="30%" height="30%">

> photograph, Dutch angle shot of a Homey Nightelf, Pink and Silver hair styled as Dreadlocks, Process Art, Nostalgic lighting, film grain, Canon eos 5d mark 4, telephoto lens

> art by Geof Kern, (art by Guo Pei:0.8), photograph, 3/4 view of a Reiwa Era Kehlani, Writing, Dark hair styled as Wavy, Necklace, Soul patch, Sunny, Dada Art, volumetric lighting, film grain, dslr, F/1.8, Plain white background

## Adding trigger words for certain models
For this example, I am using the [ReV Animated](https://civitai.com/models/7371/rev-animated) model.

I've set the Sampling method to "DPM++ SDE Karras", Sampling steps to "25" and kept the CFG Scale to "7"
You can increase the batch count, to keep creating new images.

As a __"Subject Type"__ I select __"humanoid"__. This model likes to generate humans as well.

For __"Artists"__ I select __"none"__. I don't want any interference from an artist, because we want to activate the anime-2.5D style.

As __"Type of image"__ I select __"all"__, we do want to get some surprises.

In the description for this model, it is stated to activate the anime-2.5D type pictures, we should add ((best quality)), ((masterpiece)), (detailed) in the beginning of the prompt.

This we place in the prompt prefix field. This field will always be added the the beginning to the generated prompt. Exactly what we want.

![image](https://github.com/AIrjen/OneButtonPrompt/assets/130234949/74b5b758-83fe-46cf-9759-a5a725431445)

Examples:

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/660e5184-9ac0-4cfd-bd80-f6c959023af8.png" alt="Nice BB-8" width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/2ea33957-4886-418d-bfec-a4a660cca84f.png" width="30%" height="30%">

> ((best quality)), ((masterpiece)), (detailed), Cartelcore, surreal, elegant, Narrative Australian BB-8 of Thoughts, ðŸ¥±, concept art, wearing Universal Shirt dress, DayGlo green trees, at Sunrise, horizon-centered, Cel shaded, Sepia filter

> ((best quality)), ((masterpiece)), (detailed), Sharp focus of a Smart hefty Mother, Planning events, wearing robe designed by The Hunger Games, Toe ring, Circlet, Cigarette, background is Chichen Itza, at Twilight, Dragonpunk, Rembrandt lighting

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/b6c25a09-5bf3-45ac-a205-aeeb88ce892f.png"  width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/35bcc983-1a4b-4f0d-8d40-7a773d276e57.png"  width="30%" height="30%">

> ((best quality)), ((masterpiece)), (detailed), Cluttered muscular American Quetzalcoatl, Wrestling, Dark hair styled as Bantu knots, Dark, auto-destructive art, Fish-eye Lens, surreal design, High quality

> ((best quality)), ((masterpiece)), (detailed), Exceptional slender Salvadoran Male Musician, Award-Winning Gray hair, plain background, Qajar Art, Low shutter

## Using specific artists and styles, graffiti wall art
For this example, I am using the [deliberate](https://civitai.com/models/4823/deliberate) model.

Lets say I want to generate some wall grafiti in the style of Loish. Can we do this? Yes we can!

First, lets set up our basic things again.

I've set the Sampling method to "DPM++ SDE Karras", Sampling steps to "25" and kept the CFG Scale to "7"
You can increase the batch count, to keep creating new images.

As a __"Subject Type"__ I select __"animal"__. I want to generate some animals in the art.

For __"Artists"__ I select __"none"__. I don't want any interference from adding an artist. We put our own artist in.

As __"Type of image"__ it doesn't matter, we will override this.

For __"Overwrite type of image"__ I added __"wall graffiti, doodle art"__. This will make sure this is always chosen as the image type, instead of photograph or painting for example.

Next, I add __"art by Loish"__ in the __prompt suffix field__. This artist will now always be placed at the back of the generated prompt. You could add this to the prompt prefix field as well, to get a stronger effect. You can also write it as such __"(art by Loish:1.3)"__ to have a stronger effect as well.

This way we can start exploring styles and artists. If we find something interesting during generation, we can set stuff in these fields to get more control.

![image](https://github.com/AIrjen/OneButtonPrompt/assets/130234949/d7fd8819-bdec-47f7-b3eb-676514c3336c)

Example:

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/19f2ddeb-473e-4c32-a09e-913fa9477911.png"  width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/f9f0a954-30ef-421d-97e6-8022c2fd6cff.png"  width="30%" height="30%">

> wall graffiti, doodle art of a Celestial Extraordinary Exotic Shorthair cat, Titan, Anime screencap, Embarrassing, 80mm, art by Loish

> wall graffiti, doodle art of a Misshapen Cyclops, Hazy conditions, Ultra Detailed, Peaceful, Agfacolor, art by Loish

<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/afecb619-8774-402d-be1f-82025652b369.png"  width="30%" height="30%">
<img src="https://github.com/AIrjen/OneButtonPrompt/assets/130234949/d77fd449-8f2d-4ec2-9101-d4b47bbcbb72.png"  width="30%" height="30%">

> wall graffiti, doodle art of a Dreadful Lobster, background is Unforgettable The Burning Bush, 800mm lens, CMYK Colors, art by Loish

> wall graffiti, doodle art of a Tedious Sheep, at Overcast, masterpiece, F/8, Grayscale, art by Loish

## What to do next?
Thanks for reading so far, want more?

Next up is reading [guide to override subject](https://github.com/AIrjen/OneButtonPrompt/blob/main/user_guides/override_subject_and_infinite_variations.md)

This will show you how to generate a set subject, and then One Button Prompt will generate the rest of the prompt around it. This is a very popular feature of One Button Prompt.

You can also go to [guide to IMG2IMG and ControlNET](https://github.com/AIrjen/OneButtonPrompt/blob/main/user_guides/the_next_generation_img2img_and_controlnet.md) to see how it combines with those features.
