/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.api;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileHeader;

public interface FileContentCryptor {
    public boolean canSkipAuthentication();

    public int cleartextChunkSize();

    public int ciphertextChunkSize();

    public ByteBuffer encryptChunk(ByteBuffer var1, long var2, FileHeader var4);

    public void encryptChunk(ByteBuffer var1, ByteBuffer var2, long var3, FileHeader var5);

    public ByteBuffer decryptChunk(ByteBuffer var1, long var2, FileHeader var4, boolean var5) throws AuthenticationFailedException;

    public void decryptChunk(ByteBuffer var1, ByteBuffer var2, long var3, FileHeader var5, boolean var6) throws AuthenticationFailedException;

    default public long cleartextSize(long ciphertextSize) {
        long additionalCleartextBytes;
        Preconditions.checkArgument((ciphertextSize >= 0L ? 1 : 0) != 0, (String)"expected ciphertextSize to be positive, but was %s", (long)ciphertextSize);
        long cleartextChunkSize = this.cleartextChunkSize();
        long ciphertextChunkSize = this.ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = ciphertextSize / ciphertextChunkSize;
        long additionalCiphertextBytes = ciphertextSize % ciphertextChunkSize;
        if (additionalCiphertextBytes > 0L && additionalCiphertextBytes <= overheadPerChunk) {
            throw new IllegalArgumentException("Method not defined for input value " + ciphertextSize);
        }
        long l = additionalCleartextBytes = additionalCiphertextBytes == 0L ? 0L : additionalCiphertextBytes - overheadPerChunk;
        if (!1.$assertionsDisabled && additionalCleartextBytes < 0L) {
            throw new AssertionError();
        }
        return cleartextChunkSize * numFullChunks + additionalCleartextBytes;
    }

    default public long ciphertextSize(long cleartextSize) {
        long additionalCiphertextBytes;
        Preconditions.checkArgument((cleartextSize >= 0L ? 1 : 0) != 0, (String)"expected cleartextSize to be positive, but was %s", (long)cleartextSize);
        long cleartextChunkSize = this.cleartextChunkSize();
        long ciphertextChunkSize = this.ciphertextChunkSize();
        long overheadPerChunk = ciphertextChunkSize - cleartextChunkSize;
        long numFullChunks = cleartextSize / cleartextChunkSize;
        long additionalCleartextBytes = cleartextSize % cleartextChunkSize;
        long l = additionalCiphertextBytes = additionalCleartextBytes == 0L ? 0L : additionalCleartextBytes + overheadPerChunk;
        if (!1.$assertionsDisabled && additionalCiphertextBytes < 0L) {
            throw new AssertionError();
        }
        return ciphertextChunkSize * numFullChunks + additionalCiphertextBytes;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

