/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.revealpath;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.TimeUnit;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.revealpath.RevealFailedException;
import org.cryptomator.integrations.revealpath.RevealPathService;

@Priority(value=100)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class ExplorerRevealPathService
implements RevealPathService {
    public void reveal(Path p) throws RevealFailedException {
        try {
            BasicFileAttributes attrs = Files.readAttributes(p, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            if (attrs.isDirectory()) {
                pb.command("explorer.exe", "\"" + String.valueOf(p) + "\"");
            } else {
                pb.command("explorer.exe ", "/select,", "\"" + String.valueOf(p) + "\"");
            }
            Process process = pb.start();
            if (process.waitFor(5000L, TimeUnit.MILLISECONDS)) {
                int exitValue = process.exitValue();
                if (process.exitValue() != 1) {
                    throw new RevealFailedException("Explorer.exe exited with value " + exitValue);
                }
            }
        }
        catch (IOException e) {
            throw new RevealFailedException((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RevealFailedException((Exception)e);
        }
    }

    public boolean isSupported() {
        return true;
    }
}

