/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.quickaccess;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import org.cryptomator.integrations.common.DisplayName;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.quickaccess.QuickAccessService;
import org.cryptomator.integrations.quickaccess.QuickAccessServiceException;
import org.cryptomator.windows.common.RegistryKey;
import org.cryptomator.windows.common.WindowsException;
import org.cryptomator.windows.common.WindowsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=100)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
@DisplayName(value="Explorer Navigation Pane")
public class ExplorerQuickAccessService
implements QuickAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(ExplorerQuickAccessService.class);

    public QuickAccessService.QuickAccessEntry add(Path target, String displayName) throws QuickAccessServiceException {
        if (displayName == null) {
            throw new IllegalArgumentException("Parameter 'displayname' must not be null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Parameter 'target' must not be null.");
        }
        String entryName = displayName.length() > 40 ? displayName.substring(0, 40) : displayName;
        String clsid = "{" + String.valueOf(UUID.randomUUID()) + "}";
        LOG.debug("Creating navigation pane entry with CLSID {}", (Object)clsid);
        try (WindowsRegistry.RegistryTransaction t = WindowsRegistry.startTransaction();){
            try (RegistryKey baseKey = t.createRegKey(RegistryKey.HKEY_CURRENT_USER, "Software\\Classes\\CLSID\\" + clsid, true);){
                baseKey.setStringValue("", entryName, false);
                try (RegistryKey iconKey = t.createRegKey(baseKey, "DefaultIcon", true);){
                    Optional<String> exePath = ProcessHandle.current().info().command();
                    if (exePath.isPresent()) {
                        iconKey.setStringValue("", exePath.get(), false);
                    } else {
                        iconKey.setStringValue("", "%SystemRoot%\\system32\\shell32.dll,4", true);
                    }
                }
                baseKey.setDwordValue("System.IsPinnedToNameSpaceTree", 1);
                baseKey.setDwordValue("SortOrderIndex", 65);
                try (RegistryKey inProcServer32Key = t.createRegKey(baseKey, "InProcServer32", true);){
                    inProcServer32Key.setStringValue("", "%systemroot%\\system32\\shell32.dll", true);
                }
                try (RegistryKey instanceKey = t.createRegKey(baseKey, "Instance", true);){
                    instanceKey.setStringValue("CLSID", "{0E5AAE11-A475-4c5b-AB00-C66DE400274E}", false);
                    try (RegistryKey initPropertyBagKey = t.createRegKey(instanceKey, "InitPropertyBag", true);){
                        initPropertyBagKey.setDwordValue("Attributes", 1041);
                        initPropertyBagKey.setStringValue("TargetFolderPath", target.toString(), false);
                    }
                }
                try (RegistryKey shellFolderKey = t.createRegKey(baseKey, "ShellFolder", true);){
                    shellFolderKey.setDwordValue("FolderValueFlags", 40);
                    shellFolderKey.setDwordValue("Attributes", -260046771);
                }
                LOG.trace("Created RegKey {} and subkeys, including Values", (Object)baseKey.getPath());
            }
            String nameSpaceSubKey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Desktop\\NameSpace\\" + clsid;
            try (RegistryKey nameSpaceKey = t.createRegKey(RegistryKey.HKEY_CURRENT_USER, nameSpaceSubKey, true);){
                nameSpaceKey.setStringValue("", entryName, false);
                LOG.trace("Created RegKey {} and setting default value", (Object)nameSpaceKey.getPath());
            }
            try (RegistryKey newStartPanelKey = t.createRegKey(RegistryKey.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\HideDesktopIcons\\NewStartPanel", true);){
                newStartPanelKey.setDwordValue(clsid, 1);
                LOG.trace("Set value {} for RegKey {}", (Object)clsid, (Object)newStartPanelKey.getPath());
            }
            t.commit();
        }
        catch (WindowsException e) {
            throw new QuickAccessServiceException("Adding entry to Explorer navigation pane via Windows registry failed.", (Throwable)e);
        }
        return new ExplorerQuickAccessEntry(clsid);
    }

    static class ExplorerQuickAccessEntry
    implements QuickAccessService.QuickAccessEntry {
        private final String clsid;
        private volatile boolean isClosed = false;

        private ExplorerQuickAccessEntry(String clsid) {
            this.clsid = clsid;
        }

        public synchronized void remove() throws QuickAccessServiceException {
            if (this.isClosed) {
                return;
            }
            LOG.debug("Removing navigation pane entry with CLSID {}", (Object)this.clsid);
            try (WindowsRegistry.RegistryTransaction t = WindowsRegistry.startTransaction();){
                String nameSpaceSubkey = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Desktop\\NameSpace\\" + this.clsid;
                LOG.trace("Removing RegKey {}", (Object)nameSpaceSubkey);
                t.deleteRegKey(RegistryKey.HKEY_CURRENT_USER, nameSpaceSubkey, true);
                try (RegistryKey nameSpaceKey = t.openRegKey(RegistryKey.HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\HideDesktopIcons\\NewStartPanel");){
                    LOG.trace("Removing Value {} of RegKey {}", (Object)this.clsid, (Object)nameSpaceKey.getPath());
                    nameSpaceKey.deleteValue(this.clsid, true);
                }
                try (RegistryKey baseKey = t.openRegKey(RegistryKey.HKEY_CURRENT_USER, "Software\\Classes\\CLSID\\" + this.clsid);){
                    LOG.trace("Wiping everything under RegKey {} and key itself.", (Object)baseKey.getPath());
                    baseKey.deleteTree("");
                }
                t.deleteRegKey(RegistryKey.HKEY_CURRENT_USER, "Software\\Classes\\CLSID\\" + this.clsid, true);
                t.commit();
                this.isClosed = true;
            }
            catch (WindowsException e) {
                throw new QuickAccessServiceException("Removing entry from Explorer navigation pane via Windows registry failed.", (Throwable)e);
            }
        }
    }
}

