/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.common;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.charset.StandardCharsets;
import org.cryptomator.windows.capi.common.Windows_h;
import org.cryptomator.windows.capi.winreg.Winreg_h;
import org.cryptomator.windows.common.RegistryKeyException;
import org.cryptomator.windows.common.RegistryValueException;

public class RegistryKey
implements AutoCloseable {
    static final int MAX_DATA_SIZE = 0x8000000;
    public static final RegistryKey HKEY_CURRENT_USER = new RegistryRoot(Winreg_h.HKEY_CURRENT_USER(), "HKEY_CURRENT_USER");
    public static final RegistryKey HKEY_LOCAL_MACHINE = new RegistryRoot(Winreg_h.HKEY_LOCAL_MACHINE(), "HKEY_LOCAL_MACHINE");
    public static final RegistryKey HKEY_CLASSES_ROOT = new RegistryRoot(Winreg_h.HKEY_CLASSES_ROOT(), "HKEY_CLASSES_ROOT");
    public static final RegistryKey HKEY_USERS = new RegistryRoot(Winreg_h.HKEY_USERS(), "HKEY_USERS");
    private final String path;
    private MemorySegment handle;
    private volatile boolean isClosed = false;

    RegistryKey(MemorySegment handle, String path) {
        this.handle = handle;
        this.path = path;
    }

    public String getStringValue(String name, boolean isExpandable) throws RegistryValueException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = this.getValue(arena, name, isExpandable ? Winreg_h.RRF_RT_REG_EXPAND_SZ() : Winreg_h.RRF_RT_REG_SZ());
            String string = data.getString(0L, StandardCharsets.UTF_16LE);
            return string;
        }
    }

    public int getDwordValue(String name) throws RegistryValueException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment data = this.getValue(arena, name, Winreg_h.RRF_RT_REG_DWORD());
            int n = data.get(ValueLayout.JAVA_INT, 0L);
            return n;
        }
    }

    private MemorySegment getValue(Arena arena, String name, int dwFlags) throws RegistryValueException {
        MemorySegment lpData;
        int result;
        MemorySegment lpValueName = arena.allocateFrom(name, StandardCharsets.UTF_16LE);
        MemorySegment lpDataSize = arena.allocateFrom(ValueLayout.JAVA_INT, 0);
        int bufferSize = 128;
        do {
            if ((bufferSize <<= 1) >= 0x8000000) {
                throw new RuntimeException("Getting value %s for key %s failed. Maximum buffer size of %d reached.".formatted(name, this.path, bufferSize));
            }
            lpData = arena.allocate(bufferSize);
            lpDataSize.set(ValueLayout.JAVA_INT, 0L, bufferSize);
        } while ((result = Winreg_h.RegGetValueW(this.handle, MemorySegment.NULL, lpValueName, dwFlags, MemorySegment.NULL, lpData, lpDataSize)) == Windows_h.ERROR_MORE_DATA());
        if (result == Windows_h.ERROR_SUCCESS()) {
            return lpData;
        }
        throw new RegistryValueException("winreg_h:RegGetValue", this.path, name, result);
    }

    public void setStringValue(String name, String data, boolean isExpandable) throws RegistryValueException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment lpValueName = arena.allocateFrom(name, StandardCharsets.UTF_16LE);
            MemorySegment lpValueData = arena.allocateFrom(data, StandardCharsets.UTF_16LE);
            this.setValue(lpValueName, lpValueData, isExpandable ? Winreg_h.REG_EXPAND_SZ() : Winreg_h.REG_SZ());
        }
    }

    public void setDwordValue(String name, int data) throws RegistryValueException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment lpValueName = arena.allocateFrom(name, StandardCharsets.UTF_16LE);
            MemorySegment lpValueData = arena.allocateFrom(ValueLayout.JAVA_INT, data);
            this.setValue(lpValueName, lpValueData, Winreg_h.REG_DWORD());
        }
    }

    private void setValue(MemorySegment lpValueName, MemorySegment data, int dwFlags) throws RegistryValueException {
        if (data.byteSize() > 0x8000000L) {
            throw new IllegalArgumentException("Data must be smaller than 134217728bytes.");
        }
        int result = Winreg_h.RegSetKeyValueW(this.handle, MemorySegment.NULL, lpValueName, dwFlags, data, (int)data.byteSize());
        if (result != Windows_h.ERROR_SUCCESS()) {
            throw new RegistryValueException("winreg_h:RegSetKeyValueW", this.path, lpValueName.getString(0L, StandardCharsets.UTF_16LE), result);
        }
    }

    public void deleteValue(String valueName) throws RegistryValueException {
        this.deleteValue(valueName, false);
    }

    public void deleteValue(String valueName, boolean ignoreNotExisting) throws RegistryValueException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment lpValueName = arena.allocateFrom(valueName, StandardCharsets.UTF_16LE);
            int result = Winreg_h.RegDeleteKeyValueW(this.handle, MemorySegment.NULL, lpValueName);
            if (!(result == Windows_h.ERROR_SUCCESS() || result == Windows_h.ERROR_FILE_NOT_FOUND() && ignoreNotExisting)) {
                throw new RegistryValueException("winreg_h:RegSetKeyValueW", this.path, valueName, result);
            }
        }
    }

    public void deleteTree(String subkey) throws RegistryKeyException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment lpSubkey = arena.allocateFrom(subkey, StandardCharsets.UTF_16LE);
            int result = Winreg_h.RegDeleteTreeW(this.handle, lpSubkey);
            if (result != Windows_h.ERROR_SUCCESS()) {
                throw new RegistryKeyException("winreg.h:RegDeleteTreeW", this.path + "\\" + String.valueOf(lpSubkey), result);
            }
        }
    }

    @Override
    public synchronized void close() throws RuntimeException {
        if (!this.isClosed) {
            int result = Winreg_h.RegCloseKey(this.handle);
            if (result != Windows_h.ERROR_SUCCESS()) {
                throw new RuntimeException(new RegistryKeyException("winreg.h:RegCloseKey", this.path, result));
            }
            this.handle = MemorySegment.NULL;
            this.isClosed = true;
        }
    }

    MemorySegment getHandle() {
        return this.handle;
    }

    public String getPath() {
        return this.path;
    }

    private static class RegistryRoot
    extends RegistryKey {
        RegistryRoot(MemorySegment handle, String path) {
            super(handle, path);
        }

        @Override
        public void close() {
        }
    }
}

