/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.windows.capi.common;

import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.GroupLayout;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.PaddingLayout;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.StructLayout;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Windows_h {
    static final Arena LIBRARY_ARENA = Arena.ofAuto();
    static final boolean TRACE_DOWNCALLS = Boolean.getBoolean("jextract.trace.downcalls");
    static final SymbolLookup SYMBOL_LOOKUP = SymbolLookup.libraryLookup(System.mapLibraryName("Kernel32"), LIBRARY_ARENA).or(SymbolLookup.loaderLookup()).or(Linker.nativeLinker().defaultLookup());
    public static final ValueLayout.OfBoolean C_BOOL = ValueLayout.JAVA_BOOLEAN;
    public static final ValueLayout.OfByte C_CHAR = ValueLayout.JAVA_BYTE;
    public static final ValueLayout.OfShort C_SHORT = ValueLayout.JAVA_SHORT;
    public static final ValueLayout.OfInt C_INT = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfLong C_LONG_LONG = ValueLayout.JAVA_LONG;
    public static final ValueLayout.OfFloat C_FLOAT = ValueLayout.JAVA_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE = ValueLayout.JAVA_DOUBLE;
    public static final AddressLayout C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
    public static final ValueLayout.OfInt C_LONG = ValueLayout.JAVA_INT;
    public static final ValueLayout.OfDouble C_LONG_DOUBLE = ValueLayout.JAVA_DOUBLE;
    private static final MemorySegment INVALID_HANDLE_VALUE = MemorySegment.ofAddress(-1L);
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_FILE_NOT_FOUND = 2;
    private static final int ERROR_MORE_DATA = 234;

    Windows_h() {
    }

    static void traceDowncall(String name, Object ... args) {
        String traceArgs = Arrays.stream(args).map(Object::toString).collect(Collectors.joining(", "));
        System.out.printf("%s(%s)\n", name, traceArgs);
    }

    static MemorySegment findOrThrow(String symbol) {
        return SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol));
    }

    static MethodHandle upcallHandle(Class<?> fi, String name, FunctionDescriptor fdesc) {
        try {
            return MethodHandles.lookup().findVirtual(fi, name, fdesc.toMethodType());
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static MemoryLayout align(MemoryLayout layout, long align) {
        MemoryLayout memoryLayout = layout;
        Objects.requireNonNull(memoryLayout);
        MemoryLayout memoryLayout2 = memoryLayout;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PaddingLayout.class, ValueLayout.class, GroupLayout.class, SequenceLayout.class}, (Object)memoryLayout2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PaddingLayout p;
                yield p = (PaddingLayout)memoryLayout2;
            }
            case 1 -> {
                ValueLayout v = (ValueLayout)memoryLayout2;
                yield v.withByteAlignment(align);
            }
            case 2 -> {
                GroupLayout g = (GroupLayout)memoryLayout2;
                MemoryLayout[] alignedMembers = (MemoryLayout[])g.memberLayouts().stream().map(m -> Windows_h.align(m, align)).toArray(MemoryLayout[]::new);
                if (g instanceof StructLayout) {
                    yield MemoryLayout.structLayout(alignedMembers);
                }
                yield MemoryLayout.unionLayout(alignedMembers);
            }
            case 3 -> {
                SequenceLayout s = (SequenceLayout)memoryLayout2;
                yield MemoryLayout.sequenceLayout(s.elementCount(), Windows_h.align(s.elementLayout(), align));
            }
        };
    }

    public static FunctionDescriptor CloseHandle$descriptor() {
        return CloseHandle.DESC;
    }

    public static MethodHandle CloseHandle$handle() {
        return CloseHandle.HANDLE;
    }

    public static MemorySegment CloseHandle$address() {
        return CloseHandle.ADDR;
    }

    public static int CloseHandle(MemorySegment hObject) {
        MethodHandle mh$ = CloseHandle.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Windows_h.traceDowncall("CloseHandle", hObject);
            }
            return mh$.invokeExact(hObject);
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static FunctionDescriptor GetLastError$descriptor() {
        return GetLastError.DESC;
    }

    public static MethodHandle GetLastError$handle() {
        return GetLastError.HANDLE;
    }

    public static MemorySegment GetLastError$address() {
        return GetLastError.ADDR;
    }

    public static int GetLastError() {
        MethodHandle mh$ = GetLastError.HANDLE;
        try {
            if (TRACE_DOWNCALLS) {
                Windows_h.traceDowncall("GetLastError", new Object[0]);
            }
            return mh$.invokeExact();
        }
        catch (Throwable ex$) {
            throw new AssertionError("should not reach here", ex$);
        }
    }

    public static MemorySegment INVALID_HANDLE_VALUE() {
        return INVALID_HANDLE_VALUE;
    }

    public static int ERROR_SUCCESS() {
        return 0;
    }

    public static int ERROR_FILE_NOT_FOUND() {
        return 2;
    }

    public static int ERROR_MORE_DATA() {
        return 234;
    }

    private static class CloseHandle {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_INT, C_POINTER);
        public static final MemorySegment ADDR = Windows_h.findOrThrow("CloseHandle");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private CloseHandle() {
        }
    }

    private static class GetLastError {
        public static final FunctionDescriptor DESC = FunctionDescriptor.of(C_LONG, new MemoryLayout[0]);
        public static final MemorySegment ADDR = Windows_h.findOrThrow("GetLastError");
        public static final MethodHandle HANDLE = Linker.nativeLinker().downcallHandle(ADDR, DESC, new Linker.Option[0]);

        private GetLastError() {
        }
    }
}

