/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.common;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.cryptomator.integrations.common.DisplayName;
import org.cryptomator.integrations.common.LocalizedDisplayName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NamedServiceProvider {
    default public String getName() {
        DisplayName displayName;
        LocalizedDisplayName localizedDisplayName = this.getClass().getAnnotation(LocalizedDisplayName.class);
        if (localizedDisplayName != null) {
            try {
                return ResourceBundle.getBundle(localizedDisplayName.bundle()).getString(localizedDisplayName.key());
            }
            catch (MissingResourceException e) {
                Class<?> clazz = this.getClass();
                Logger logger = LoggerFactory.getLogger(clazz);
                logger.warn("Failed to load localized display name for {}. Falling back to not-localized display name/class name.", (Object)clazz.getName(), (Object)e);
            }
        }
        if ((displayName = this.getClass().getAnnotation(DisplayName.class)) != null) {
            return displayName.value();
        }
        return this.getClass().getName();
    }
}

