/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav;

import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import org.cryptomator.frontend.webdav.DefaultServlet;
import org.cryptomator.frontend.webdav.ServerLifecycleException;
import org.cryptomator.frontend.webdav.WebDavServerFactory;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.cryptomator.frontend.webdav.servlet.WebDavServletFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDavServer {
    private static final Logger LOG = LoggerFactory.getLogger(WebDavServer.class);
    private final Server server;
    private final ExecutorService executorService;
    private final ServerConnector localConnector;
    private final ContextHandlerCollection servletCollectionCtx;
    private final DefaultServlet defaultServlet;

    WebDavServer(Server server, ExecutorService executorService, ServerConnector connector, ContextHandlerCollection servletCollectionCtx, DefaultServlet defaultServlet) {
        this.server = server;
        this.executorService = executorService;
        this.localConnector = connector;
        this.servletCollectionCtx = servletCollectionCtx;
        this.defaultServlet = defaultServlet;
    }

    public static WebDavServer create(InetSocketAddress bindAddr) {
        return WebDavServerFactory.createWebDavServer(bindAddr);
    }

    public synchronized void start() throws ServerLifecycleException {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Server has already been terminated.");
        }
        try {
            this.server.start();
            LOG.info("WebDavServer started.");
        }
        catch (Exception e) {
            throw new ServerLifecycleException("Server couldn't be started", e);
        }
    }

    public synchronized void stop() throws ServerLifecycleException {
        try {
            this.server.stop();
            LOG.info("WebDavServer stopped.");
        }
        catch (Exception e) {
            throw new ServerLifecycleException("Server couldn't be stopped", e);
        }
    }

    public synchronized void terminate() throws ServerLifecycleException {
        this.stop();
        this.executorService.shutdownNow();
    }

    public WebDavServletController createWebDavServlet(Path rootPath, String contextPath) {
        return WebDavServletFactory.createServletController(rootPath, contextPath, this.localConnector, this.servletCollectionCtx, this.defaultServlet);
    }
}

