/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.api;

import java.util.Arrays;
import java.util.ServiceLoader;
import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.platforms.Architecture;
import org.cryptomator.jfuse.api.platforms.OperatingSystem;
import org.cryptomator.jfuse.api.platforms.SupportedPlatform;
import org.jetbrains.annotations.Nullable;

public interface FuseBuilder {
    public static FuseBuilder getSupported() throws UnsupportedOperationException {
        return ServiceLoader.load(FuseBuilder.class).stream().filter(FuseBuilder::isSupported).findAny().map(ServiceLoader.Provider::get).orElseThrow(() -> new UnsupportedOperationException("No implementation of FuseProvider found for the current platform."));
    }

    private static boolean isSupported(ServiceLoader.Provider<FuseBuilder> provider) {
        return Arrays.stream((SupportedPlatform[])provider.type().getAnnotationsByType(SupportedPlatform.class)).filter(platform -> OperatingSystem.CURRENT.equals((Object)platform.os())).anyMatch(platform -> Architecture.CURRENT.equals((Object)platform.arch()));
    }

    public Errno errno();

    public void setLibraryPath(@Nullable String var1);

    public Fuse build(FuseOperations var1) throws UnsatisfiedLinkError;
}

