/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client;

import io.github.coffeelibs.tinyoauth2client.PKCE;
import io.github.coffeelibs.tinyoauth2client.TinyOAuth2Client;
import io.github.coffeelibs.tinyoauth2client.http.RedirectTarget;
import io.github.coffeelibs.tinyoauth2client.http.response.Response;
import io.github.coffeelibs.tinyoauth2client.util.RandomUtil;
import io.github.coffeelibs.tinyoauth2client.util.URIUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonBlocking;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Experimental
public class AuthorizationCodeGrant {
    public static final int[] SYSTEM_ASSIGNED_PORT = new int[]{0};
    @VisibleForTesting
    final TinyOAuth2Client client;
    @VisibleForTesting
    final URI authEndpoint;
    @VisibleForTesting
    final PKCE pkce;
    @VisibleForTesting
    String redirectPath = "/" + RandomUtil.randomToken(16);
    @VisibleForTesting
    int[] redirectPorts = SYSTEM_ASSIGNED_PORT;
    @VisibleForTesting
    Response successResponse = Response.html(Response.Status.OK, "<html><body>Success</body></html>");
    @VisibleForTesting
    Response errorResponse = Response.html(Response.Status.OK, "<html><body>Error</body></html>");

    AuthorizationCodeGrant(TinyOAuth2Client client, URI authEndpoint, PKCE pkce) {
        this.client = Objects.requireNonNull(client);
        this.authEndpoint = Objects.requireNonNull(authEndpoint);
        this.pkce = Objects.requireNonNull(pkce);
    }

    @Contract(value="!null -> this")
    public AuthorizationCodeGrant setSuccessResponse(Response response) {
        this.successResponse = Objects.requireNonNull(response);
        return this;
    }

    @Contract(value="!null -> this")
    public AuthorizationCodeGrant setErrorResponse(Response response) {
        this.errorResponse = Objects.requireNonNull(response);
        return this;
    }

    @Contract(value="!null -> this")
    public AuthorizationCodeGrant setRedirectPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path should be absolute");
        }
        this.redirectPath = path;
        return this;
    }

    @Contract(value="!null -> this")
    public AuthorizationCodeGrant setRedirectPort(int ... ports) {
        this.redirectPorts = Objects.requireNonNull(ports);
        return this;
    }

    @NonBlocking
    public CompletableFuture<HttpResponse<String>> authorizeAsync(HttpClient httpClient, Consumer<URI> browser, String ... scopes) {
        Executor executor = httpClient.executor().orElse(ForkJoinPool.commonPool());
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.requestAuthCode(browser, scopes);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, executor).thenCompose(authorizedGrant -> authorizedGrant.getAccessTokenAsync(httpClient));
    }

    @Blocking
    public HttpResponse<String> authorize(HttpClient httpClient, Consumer<URI> browser, String ... scopes) throws IOException, InterruptedException {
        return this.requestAuthCode(browser, scopes).getAccessToken(httpClient);
    }

    @Blocking
    @VisibleForTesting
    WithAuthorizationCode requestAuthCode(Consumer<URI> browser, String ... scopes) throws IOException {
        try (RedirectTarget redirectTarget = RedirectTarget.start(this.redirectPath, this.redirectPorts);){
            redirectTarget.setSuccessResponse(this.successResponse);
            redirectTarget.setErrorResponse(this.errorResponse);
            URI authUri = this.buildAuthUri(redirectTarget.getRedirectUri(), redirectTarget.getCsrfToken(), Set.of(scopes));
            ForkJoinPool.commonPool().execute(() -> browser.accept(authUri));
            String code = redirectTarget.receive();
            WithAuthorizationCode withAuthorizationCode = new WithAuthorizationCode(redirectTarget.getRedirectUri().toASCIIString(), code);
            return withAuthorizationCode;
        }
    }

    @VisibleForTesting
    URI buildAuthUri(URI redirectEndpoint, String csrfToken, Set<String> scopes) {
        Object queryString = "";
        if (this.authEndpoint.getRawQuery() != null) {
            queryString = this.authEndpoint.getRawQuery() + "&";
        }
        queryString = (String)queryString + URIUtil.buildQueryString(Map.of("response_type", "code", "client_id", this.client.clientId, "state", csrfToken, "code_challenge", this.pkce.getChallenge(), "code_challenge_method", "S256", "redirect_uri", redirectEndpoint.toASCIIString()));
        if (!scopes.isEmpty()) {
            queryString = (String)queryString + "&" + URIUtil.buildQueryString(Map.of("scope", String.join((CharSequence)" ", scopes)));
        }
        return URI.create(this.authEndpoint.getScheme() + "://" + this.authEndpoint.getRawAuthority() + this.authEndpoint.getRawPath() + "?" + (String)queryString);
    }

    class WithAuthorizationCode {
        private final String redirectUri;
        private final String authorizationCode;

        @VisibleForTesting
        WithAuthorizationCode(String redirectUri, String authorizationCode) {
            this.redirectUri = redirectUri;
            this.authorizationCode = authorizationCode;
        }

        @VisibleForTesting
        HttpRequest buildTokenRequest() {
            return AuthorizationCodeGrant.this.client.createTokenRequest(Map.of("grant_type", "authorization_code", "client_id", AuthorizationCodeGrant.this.client.clientId, "code_verifier", AuthorizationCodeGrant.this.pkce.getVerifier(), "code", this.authorizationCode, "redirect_uri", this.redirectUri)).build();
        }

        public CompletableFuture<HttpResponse<String>> getAccessTokenAsync(HttpClient httpClient) {
            return httpClient.sendAsync(this.buildTokenRequest(), HttpResponse.BodyHandlers.ofString());
        }

        @Blocking
        public HttpResponse<String> getAccessToken(HttpClient httpClient) throws IOException, InterruptedException {
            return httpClient.send(this.buildTokenRequest(), HttpResponse.BodyHandlers.ofString());
        }
    }
}

