/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFile
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFile.class);
    private final Path path;
    private final FileChannel channel;
    private volatile boolean dirty;

    private OpenFile(Path path, FileChannel channel) {
        this.path = path;
        this.channel = channel;
        this.dirty = false;
    }

    static OpenFile create(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        FileChannel ch = FileChannel.open(path, options, attrs);
        return new OpenFile(path, ch);
    }

    public int read(ByteBuffer buf, long num, long offset) throws IOException {
        int read;
        int r;
        long size = this.channel.size();
        if (offset >= size) {
            return 0;
        }
        if (num > Integer.MAX_VALUE) {
            throw new IOException("Requested too many bytes");
        }
        int toRead = (int)Math.min(num, (long)buf.limit());
        for (read = 0; read < toRead; read += r) {
            r = this.channel.read(buf, offset + (long)read);
            if (r != -1) continue;
            LOG.trace("Reached EOF");
            break;
        }
        return read;
    }

    public int write(ByteBuffer buf, long num, long offset) throws IOException {
        int written;
        this.dirty = true;
        if (num > Integer.MAX_VALUE) {
            throw new IOException("Requested too many bytes");
        }
        int toWrite = (int)Math.min(num, (long)buf.limit());
        for (written = 0; written < toWrite; written += this.channel.write(buf, offset + (long)written)) {
        }
        return written;
    }

    boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public void fsync(boolean metaData) throws IOException {
        this.channel.force(metaData);
        this.dirty = false;
    }

    public void truncate(long size) throws IOException {
        FileChannelUtil.truncateOrExpand(this.channel, size);
    }

    public String toString() {
        return "OpenFile{path=" + String.valueOf(this.path) + ", channel=" + String.valueOf(this.channel) + "}";
    }
}

