/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration;

import com.google.common.collect.ImmutableMap;
import dagger.internal.DaggerGenerated;
import dagger.internal.Preconditions;
import java.security.SecureRandom;
import java.util.Map;
import org.cryptomator.cryptofs.migration.Migration;
import org.cryptomator.cryptofs.migration.MigrationComponent;
import org.cryptomator.cryptofs.migration.MigrationModule;
import org.cryptomator.cryptofs.migration.MigrationModule_ProvideFileSystemCapabilityCheckerFactory;
import org.cryptomator.cryptofs.migration.MigrationModule_ProvideVersion6MigratorFactory;
import org.cryptomator.cryptofs.migration.MigrationModule_ProvideVersion7MigratorFactory;
import org.cryptomator.cryptofs.migration.MigrationModule_ProvideVersion8MigratorFactory;
import org.cryptomator.cryptofs.migration.Migrators;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptofs.migration.v6.Version6Migrator;
import org.cryptomator.cryptofs.migration.v7.Version7Migrator;
import org.cryptomator.cryptofs.migration.v8.Version8Migrator;

@DaggerGenerated
final class DaggerMigrationComponent {
    private DaggerMigrationComponent() {
    }

    public static MigrationComponent.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements MigrationComponent.Builder {
        private SecureRandom csprng;

        private Builder() {
        }

        @Override
        public Builder csprng(SecureRandom csprng) {
            this.csprng = (SecureRandom)Preconditions.checkNotNull((Object)csprng);
            return this;
        }

        @Override
        public MigrationComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.csprng, SecureRandom.class);
            return new MigrationComponentImpl(new MigrationModule(), this.csprng);
        }
    }

    private static final class MigrationComponentImpl
    implements MigrationComponent {
        private final MigrationModule migrationModule;
        private final SecureRandom csprng;
        private final MigrationComponentImpl migrationComponentImpl = this;

        private MigrationComponentImpl(MigrationModule migrationModuleParam, SecureRandom csprngParam) {
            this.migrationModule = migrationModuleParam;
            this.csprng = csprngParam;
        }

        private Version6Migrator version6Migrator() {
            return new Version6Migrator(this.csprng);
        }

        private Migrator provideVersion6Migrator() {
            return MigrationModule_ProvideVersion6MigratorFactory.provideVersion6Migrator(this.migrationModule, this.version6Migrator());
        }

        private Version7Migrator version7Migrator() {
            return new Version7Migrator(this.csprng);
        }

        private Migrator provideVersion7Migrator() {
            return MigrationModule_ProvideVersion7MigratorFactory.provideVersion7Migrator(this.migrationModule, this.version7Migrator());
        }

        private Version8Migrator version8Migrator() {
            return new Version8Migrator(this.csprng);
        }

        private Migrator provideVersion8Migrator() {
            return MigrationModule_ProvideVersion8MigratorFactory.provideVersion8Migrator(this.migrationModule, this.version8Migrator());
        }

        private Map<Migration, Migrator> mapOfMigrationAndMigrator() {
            return ImmutableMap.of((Object)((Object)Migration.FIVE_TO_SIX), (Object)this.provideVersion6Migrator(), (Object)((Object)Migration.SIX_TO_SEVEN), (Object)this.provideVersion7Migrator(), (Object)((Object)Migration.SEVEN_TO_EIGHT), (Object)this.provideVersion8Migrator());
        }

        @Override
        public Migrators migrators() {
            return new Migrators(this.mapOfMigrationAndMigrator(), MigrationModule_ProvideFileSystemCapabilityCheckerFactory.provideFileSystemCapabilityChecker(this.migrationModule));
        }
    }
}

