/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.type;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public class UnknownType
implements DiagnosticResult {
    final Path cipherDir;

    UnknownType(Path cipherDir) {
        this.cipherDir = cipherDir;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    void fix(Path pathToVault) throws IOException {
        Files.delete(pathToVault.resolve(this.cipherDir));
    }

    @Override
    public Optional<DiagnosticResult.Fix> getFix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) {
        return Optional.of(() -> this.fix(pathToVault));
    }

    @Override
    public String toString() {
        return String.format("C9r dir %s of unknown type.", this.cipherDir);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.cipherDir.toString());
    }
}

