/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.type;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.health.api.CheckFailed;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.cryptofs.health.type.AmbiguousType;
import org.cryptomator.cryptofs.health.type.KnownType;
import org.cryptomator.cryptofs.health.type.UnknownType;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiphertextFileTypeCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(CiphertextFileTypeCheck.class);
    private static final int MAX_TRAVERSAL_DEPTH = 3;

    @Override
    public String name() {
        return "Resource Type Check";
    }

    @Override
    public void check(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor, Consumer<DiagnosticResult> resultCollector) {
        Path dataDirPath = pathToVault.resolve("d");
        DirVisitor dirVisitor = new DirVisitor(resultCollector);
        try {
            Files.walkFileTree(dataDirPath, Set.of(), 3, dirVisitor);
        }
        catch (IOException e) {
            LOG.error("Traversal of data dir failed.", (Throwable)e);
            resultCollector.accept(new CheckFailed("Traversal of data dir failed. See log for details."));
        }
    }

    static class DirVisitor
    extends SimpleFileVisitor<Path> {
        private final Consumer<DiagnosticResult> resultCollector;

        public DirVisitor(Consumer<DiagnosticResult> resultCollector) {
            this.resultCollector = resultCollector;
        }

        @Override
        public FileVisitResult visitFile(Path dir, BasicFileAttributes attrs) {
            String name = dir.getFileName().toString();
            if (attrs.isDirectory() && name.endsWith(".c9r")) {
                this.checkCiphertextType(dir, false);
            } else if (attrs.isDirectory() && name.endsWith(".c9s")) {
                this.checkCiphertextType(dir, true);
            }
            return FileVisitResult.CONTINUE;
        }

        void checkCiphertextType(Path dir, boolean checkForContentsC9r) {
            Set<CiphertextFileType> types = this.containedCiphertextFileTypes(dir, checkForContentsC9r);
            this.resultCollector.accept(switch (types.size()) {
                case 0 -> new UnknownType(dir);
                case 1 -> new KnownType(dir, types.iterator().next());
                default -> new AmbiguousType(dir, types);
            });
        }

        private Set<CiphertextFileType> containedCiphertextFileTypes(Path dir, boolean checkForContentsC9r) {
            EnumSet<CiphertextFileType> result = EnumSet.noneOf(CiphertextFileType.class);
            if (this.containsDirFile(dir)) {
                result.add(CiphertextFileType.DIRECTORY);
            }
            if (this.containsSymlinkFile(dir)) {
                result.add(CiphertextFileType.SYMLINK);
            }
            if (checkForContentsC9r && this.containsContentsFile(dir)) {
                result.add(CiphertextFileType.FILE);
            }
            return result;
        }

        private boolean containsDirFile(Path path) {
            Path dirc9r = path.resolve("dir.c9r");
            return Files.isRegularFile(dirc9r, LinkOption.NOFOLLOW_LINKS);
        }

        private boolean containsSymlinkFile(Path path) {
            Path symlinkc9r = path.resolve("symlink.c9r");
            return Files.isRegularFile(symlinkc9r, LinkOption.NOFOLLOW_LINKS);
        }

        private boolean containsContentsFile(Path path) {
            Path contentsc9r = path.resolve("contents.c9r");
            return Files.isRegularFile(contentsc9r, LinkOption.NOFOLLOW_LINKS);
        }
    }
}

