/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class DirIdCollision
implements DiagnosticResult {
    final String dirId;
    final Path dirFile;
    final Path otherDirFile;

    DirIdCollision(String dirId, Path dirFile, Path otherDirFile) {
        this.dirId = dirId;
        this.dirFile = dirFile;
        this.otherDirFile = otherDirFile;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public String toString() {
        return String.format("Directory ID reused: %s found in %s and %s", this.dirId, this.dirFile, this.otherDirFile);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID", this.dirId, "Directory ID File", this.dirFile.toString(), "Other Directory ID File", this.otherDirFile.toString());
    }
}

