/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cryptomator.webdav.core.filters.HttpFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MkcolComplianceFilter
implements HttpFilter {
    private static final Logger LOG = LoggerFactory.getLogger(MkcolComplianceFilter.class);
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";

    @Override
    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean hasBody;
        boolean bl = hasBody = request.getContentLengthLong() > 0L || request.getHeader(HEADER_TRANSFER_ENCODING) != null;
        if (METHOD_MKCOL.equalsIgnoreCase(request.getMethod()) && hasBody) {
            LOG.warn("Blocked invalid MKCOL request to {}", (Object)request.getRequestURI());
            response.sendError(415, "MKCOL with body not supported.");
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

