/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import dagger.Lazy;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.concurrent.Task;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.mount.ConflictingMountServiceException;
import org.cryptomator.common.mount.IllegalMountPointException;
import org.cryptomator.common.settings.WhenUnlocked;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.common.VaultService;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.fxapp.PrimaryStage;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.unlock.UnlockCancelledException;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnlockScoped
public class UnlockWorkflow
extends Task<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(UnlockWorkflow.class);
    private final Stage mainWindow;
    private final Stage window;
    private final Vault vault;
    private final VaultService vaultService;
    private final Lazy<Scene> successScene;
    private final Lazy<Scene> invalidMountPointScene;
    private final Lazy<Scene> restartRequiredScene;
    private final FxApplicationWindows appWindows;
    private final KeyLoadingStrategy keyLoadingStrategy;
    private final ObjectProperty<IllegalMountPointException> illegalMountPointException;

    @Inject
    UnlockWorkflow(@PrimaryStage Stage mainWindow, @UnlockWindow Stage window, @UnlockWindow Vault vault, VaultService vaultService, @FxmlScene(value=FxmlFile.UNLOCK_SUCCESS) Lazy<Scene> successScene, @FxmlScene(value=FxmlFile.UNLOCK_INVALID_MOUNT_POINT) Lazy<Scene> invalidMountPointScene, @FxmlScene(value=FxmlFile.UNLOCK_REQUIRES_RESTART) Lazy<Scene> restartRequiredScene, FxApplicationWindows appWindows, @UnlockWindow KeyLoadingStrategy keyLoadingStrategy, @UnlockWindow ObjectProperty<IllegalMountPointException> illegalMountPointException) {
        this.mainWindow = mainWindow;
        this.window = window;
        this.vault = vault;
        this.vaultService = vaultService;
        this.successScene = successScene;
        this.invalidMountPointScene = invalidMountPointScene;
        this.restartRequiredScene = restartRequiredScene;
        this.appWindows = appWindows;
        this.keyLoadingStrategy = keyLoadingStrategy;
        this.illegalMountPointException = illegalMountPointException;
    }

    protected Void call() throws InterruptedException, IOException, CryptoException, MountFailedException {
        try {
            this.keyLoadingStrategy.use(this.vault::unlock);
            return null;
        }
        catch (UnlockCancelledException e) {
            this.cancel(false);
            return null;
        }
        catch (IOException | RuntimeException | MountFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception type", e);
        }
    }

    private void handleIllegalMountPointError(IllegalMountPointException impe) {
        Platform.runLater(() -> {
            this.illegalMountPointException.set((Object)impe);
            this.window.setScene((Scene)this.invalidMountPointScene.get());
            this.window.show();
        });
    }

    private void handleConflictingMountServiceException() {
        Platform.runLater(() -> {
            this.window.setScene((Scene)this.restartRequiredScene.get());
            this.window.show();
        });
    }

    private void handleGenericError(Throwable e) {
        LOG.error("Unlock failed for technical reasons.", e);
        this.appWindows.showErrorWindow(e, this.window, null);
    }

    protected void succeeded() {
        LOG.info("Unlock of '{}' succeeded.", (Object)this.vault.getDisplayName());
        switch ((WhenUnlocked)((Object)this.vault.getVaultSettings().actionAfterUnlock.get())) {
            case ASK: {
                Platform.runLater(() -> {
                    this.window.setScene((Scene)this.successScene.get());
                    this.window.show();
                    double x = this.mainWindow.getX() + (this.mainWindow.getWidth() - this.window.getWidth()) / 2.0;
                    double y = this.mainWindow.getY() + (this.mainWindow.getHeight() - this.window.getHeight()) / 2.0;
                    if (!this.mainWindow.isShowing()) {
                        Screen screen = Screen.getScreensForRectangle((double)this.mainWindow.getX(), (double)this.mainWindow.getY(), (double)this.mainWindow.getWidth(), (double)this.mainWindow.getHeight()).stream().findFirst().orElse(Screen.getPrimary());
                        Rectangle2D bounds = screen.getVisualBounds();
                        x = bounds.getMinX() + (bounds.getWidth() - this.window.getWidth()) / 2.0;
                        y = bounds.getMinY() + (bounds.getHeight() - this.window.getHeight()) / 2.0;
                    }
                    this.window.setX(x);
                    this.window.setY(y);
                });
                break;
            }
            case REVEAL: {
                Platform.runLater(() -> ((Stage)this.window).close());
                this.vaultService.reveal(this.vault);
                break;
            }
            case IGNORE: {
                Platform.runLater(() -> ((Stage)this.window).close());
            }
        }
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
    }

    protected void failed() {
        Throwable throwable;
        LOG.info("Unlock of '{}' failed.", (Object)this.vault.getDisplayName());
        Throwable throwable2 = throwable = super.getException();
        Objects.requireNonNull(throwable2);
        Throwable throwable3 = throwable2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IllegalMountPointException.class, ConflictingMountServiceException.class}, (Object)throwable3, n)) {
            case 0: {
                IllegalMountPointException e = (IllegalMountPointException)throwable3;
                this.handleIllegalMountPointError(e);
                break;
            }
            case 1: {
                this.handleConflictingMountServiceException();
                break;
            }
            default: {
                this.handleGenericError(throwable);
            }
        }
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }

    protected void cancelled() {
        LOG.debug("Unlock of '{}' canceled.", (Object)this.vault.getDisplayName());
        this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
    }
}

