/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.unlock;

import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.fxapp.FxApplicationWindows;
import org.cryptomator.ui.unlock.UnlockScoped;
import org.cryptomator.ui.unlock.UnlockWindow;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;

@UnlockScoped
public class UnlockRequiresRestartController
implements FxController {
    private final Stage window;
    private final ResourceBundle resourceBundle;
    private final FxApplicationWindows appWindows;
    private final Vault vault;

    @Inject
    UnlockRequiresRestartController(@UnlockWindow Stage window, ResourceBundle resourceBundle, FxApplicationWindows appWindows, @UnlockWindow Vault vault) {
        this.window = window;
        this.resourceBundle = resourceBundle;
        this.appWindows = appWindows;
        this.vault = vault;
    }

    public void initialize() {
        this.window.setTitle(String.format(this.resourceBundle.getString("unlock.error.title"), this.vault.getDisplayName()));
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void closeAndOpenVaultOptions() {
        this.appWindows.showVaultOptionsWindow(this.vault, SelectedVaultOptionsTab.MOUNT);
        this.window.close();
    }
}

